/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.utils;

import com.whatsapp.campaign.dto.DailyCountDTO;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Utils {
    public static String cleanString(String input) {
        if (input == null) {
            return "";
        }
        return input.replaceAll("[\\t\\n\\r]", " ").replaceAll("\\s{2,}", " ").trim();
    }

    public static List<DailyCountDTO> completarDiasFaltantes(List<DailyCountDTO> resultados, LocalDate inicio, LocalDate fin) {
        Map<String, Long> map = resultados.stream().collect(Collectors.toMap(DailyCountDTO::getDate, DailyCountDTO::getTotal));
        ArrayList<DailyCountDTO> resultadoCompleto = new ArrayList<DailyCountDTO>();
        LocalDate actual = inicio;
        while (!actual.isAfter(fin)) {
            String fechaStr = actual.toString();
            long total = map.getOrDefault(fechaStr, 0L);
            resultadoCompleto.add(new DailyCountDTO(fechaStr, total));
            actual = actual.plusDays(1L);
        }
        return resultadoCompleto;
    }

    public static LocalDateTime convertDateToLocaDateTime(LocalDate dateObject) {
        return dateObject.atTime(0, 0, 0);
    }
}

