/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.utils;

import com.whatsapp.campaign.data.ExtractData;
import com.whatsapp.campaign.data.UserResponse;
import com.whatsapp.campaign.data.whatsapp.StatusMessages;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ResponseUtilStated {
    private static final Logger log = LoggerFactory.getLogger(ResponseUtilStated.class);

    public List<ExtractData> getStatuses(UserResponse userResponse) {
        ArrayList<ExtractData> statusData = new ArrayList<ExtractData>();
        if (userResponse == null || userResponse.getEntry() == null) {
            return statusData;
        }
        for (UserResponse.Entry entry : userResponse.getEntry()) {
            String businessAccountId = String.valueOf(entry.getId());
            for (UserResponse.Change change : entry.getChanges()) {
                UserResponse.Value valueChange = change.getValue();
                if (valueChange.getStatuses() == null) continue;
                for (StatusMessages status : valueChange.getStatuses()) {
                    String messageId = status.getId();
                    String statusType = status.getStatus();
                    String recipient = status.getRecipientId();
                    String timestamp = status.getTimestamp();
                    log.info("\ud83d\udcca Estado recibido - ID: {}, estado: {}, para: {}, en: {}", new Object[]{messageId, statusType, recipient, timestamp});
                    ExtractData data = new ExtractData();
                    data.setIdConversation(recipient);
                    data.setCanal("whatsapp");
                    data.setType("status");
                    data.setMessage(statusType);
                    data.setMessageId(messageId);
                    data.setNick(null);
                    data.setBusinessAccountId(businessAccountId);
                    statusData.add(data);
                }
            }
        }
        return statusData;
    }
}

