/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.sender;

import com.whatsapp.campaign.cache.ClientCacheService;
import com.whatsapp.campaign.cache.MessageStateCacheService;
import com.whatsapp.campaign.cache.RelationCampaignHistory;
import com.whatsapp.campaign.cache.RelationCampaignStated;
import com.whatsapp.campaign.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.campaign.data.TemplateWhatsApp;
import com.whatsapp.campaign.data.WhatsAppCampaignModel;
import com.whatsapp.campaign.data.WhatsAppTemplateRequest;
import com.whatsapp.campaign.entity.CampaignStated;
import com.whatsapp.campaign.entity.TCampaign;
import com.whatsapp.campaign.entity.TCampaignDetail;
import com.whatsapp.campaign.exceptions.CustomException;
import com.whatsapp.campaign.repository.CampaignDetailRepository;
import com.whatsapp.campaign.repository.CampaignStatedRepository;
import com.whatsapp.campaign.repository.ClientRepository;
import com.whatsapp.campaign.service.BusinessPhoneService;
import com.whatsapp.campaign.service.CampaignService;
import com.whatsapp.campaign.utils.CampaignModelUtil;
import com.whatsapp.campaign.utils.ErrorParserUtil;
import com.whatsapp.campaign.utils.PhoneNumberUtil;
import com.whatsapp.campaign.utils.StatusUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TemplateMessageSenderService {
    private static final Logger log = LoggerFactory.getLogger(TemplateMessageSenderService.class);
    private final CampaignService campaignService;
    private final ApiWhatsAppService whatsAppService;
    private final MessageStateCacheService messageStateCacheService;
    private final RelationCampaignStated relationCampaignStated;
    private final RelationCampaignHistory relationCampaignHistory;
    private final CampaignDetailRepository campaignDetailRepository;
    private final BusinessPhoneService businessPhoneService;
    private final CampaignStatedRepository campaignStatedRepository;
    private final ClientCacheService clientCacheService;
    private final ClientRepository clientRepository;

    public Mono<String> sendMessageFromTemplateListItem(List<WhatsAppTemplateRequest> listRequest, String userName) {
        if (listRequest == null || listRequest.isEmpty()) {
            log.warn("La lista de plantillas est\u00e1 vac\u00eda, no se enviar\u00e1 ning\u00fan mensaje.");
            return Mono.error((Throwable)new CustomException("La lista de plantillas est\u00e1 vac\u00eda, no se enviar\u00e1 ning\u00fan mensaje.", HttpStatus.NOT_FOUND));
        }
        return this.businessPhoneService.findIdByPhoneId().doOnError(e -> log.error("Error al obtener el ID del tel\u00e9fono de WhatsApp: {}", (Object)e.getMessage(), e)).flatMap(phoneId -> {
            TCampaign campaignHeader = CampaignModelUtil.buildCampaignHeader((List)listRequest, (String)userName);
            return this.campaignService.saveCampaignHeader(campaignHeader).flatMap(header -> this.sendMessages(listRequest, userName, header.getId()));
        });
    }

    private Mono<String> sendMessages(List<WhatsAppTemplateRequest> listRequest, String userName, Long campaignId) {
        log.info("Iniciando env\u00edo de {} mensajes para la campa\u00f1a {} por el usuario {}", new Object[]{listRequest.size(), campaignId, userName});
        return Flux.fromIterable(listRequest).window(Duration.ofSeconds(5L)).flatMapSequential(batch -> batch.take(30L).flatMap(request -> this.sendMessageTemplateCartItem(request, userName, campaignId).flatMap(response -> {
            String messageId = response.getMessageId();
            String status = response.getMessageStatus() != null ? response.getMessageStatus() : StatusUtil.ST_UNKNOWN;
            log.info("Mensaje enviado exitosamente a {}. messageId: {}, status: {}", new Object[]{request.getNumber(), messageId, status});
            log.debug("Guardando estado del mensaje en cache. messageId: {}, status: {}", (Object)messageId, (Object)status);
            log.info("request for stated: {}", request);
            CampaignStated c_stated = new CampaignStated();
            c_stated.setStateType(status);
            c_stated.setCampaignId(campaignId);
            return this.messageStateCacheService.setState(messageId, status);
        }).onErrorResume(error -> {
            log.error("Error al enviar mensaje a {}: {}", new Object[]{request.getNumber(), error.getMessage(), error});
            return Mono.empty();
        }))).doOnError(error -> log.error("Error inesperado durante el env\u00edo masivo de mensajes: {}", (Object)error.getMessage(), error)).doOnTerminate(() -> log.info("Finaliz\u00f3 el env\u00edo de mensajes para la campa\u00f1a {}", (Object)campaignId)).then(Mono.just((Object)"Finaliz\u00f3 el env\u00edo de mensajes"));
    }

    private Mono<TCampaignDetail> sendMessageTemplateCartItem(WhatsAppTemplateRequest request, String userName, Long campaignHeaderId) {
        WhatsAppCampaignModel campaign = this.buildCampaign(request);
        String conversationId = campaign.getTo();
        return this.whatsAppService.sendMessageTemplate(campaign).flatMap(response -> {
            log.info("\u2705 WhatsApp API response: {}", response);
            String messageId = CampaignModelUtil.extractMessageId((String)response);
            TCampaignDetail successDetail = CampaignModelUtil.buildAceptedCampaignModelDetail((String)conversationId, (String)request.getTemplate(), (Long)campaignHeaderId, (String)messageId);
            return this.campaignDetailRepository.save((Object)successDetail).flatMap(savedDetail -> {
                log.info("\ud83d\udcbe Campaign detail saved: {}", savedDetail);
                CampaignStated state = new CampaignStated();
                state.setStateType(savedDetail.getMessageStatus());
                state.setCampaignId(savedDetail.getId());
                Mono saveStateMono = this.campaignStatedRepository.save((Object)state).doOnSuccess(s -> log.info("\ud83d\udce5 Campaign state saved: {}", s)).then();
                Mono setStateRelationMono = this.relationCampaignStated.setData(savedDetail.getMessageId(), String.valueOf(savedDetail.getId()));
                Mono historyRelationMono = this.relationCampaignHistory.exists(savedDetail.getConversationId()).flatMap(exists -> {
                    if (exists.booleanValue()) {
                        return this.relationCampaignHistory.delete(savedDetail.getConversationId()).then(this.relationCampaignHistory.setData(savedDetail.getConversationId(), String.valueOf(savedDetail.getId())));
                    }
                    return this.relationCampaignHistory.setData(savedDetail.getConversationId(), String.valueOf(savedDetail.getId()));
                }).then();
                Mono cacheClientMono = this.clientRepository.findByNumberphone(savedDetail.getConversationId()).flatMap(client -> {
                    log.info("\ud83d\udce6 Caching client: {}", (Object)client.getNumberphone());
                    return this.clientCacheService.setData(client.getNumberphone(), String.valueOf(client.getId()));
                }).onErrorResume(cacheError -> {
                    log.warn("\u26a0\ufe0f Error caching client: {}", (Object)cacheError.getMessage());
                    return Mono.empty();
                });
                return Mono.when((Publisher[])new Publisher[]{saveStateMono, setStateRelationMono, historyRelationMono, cacheClientMono}).thenReturn(savedDetail);
            });
        }).onErrorResume(error -> {
            String errorMessage = ErrorParserUtil.extractErrorMessage((Throwable)error);
            log.error("\u274c Error in sendMessageTemplateCartItem: {}", (Object)errorMessage);
            TCampaignDetail failedDetail = CampaignModelUtil.buildFailedCampaignModelDetail((String)conversationId, (String)request.getTemplate(), (String)errorMessage, (Long)campaignHeaderId);
            return this.campaignDetailRepository.save((Object)failedDetail).doOnSuccess(f -> log.info("\ud83d\udeab Failed campaign detail saved: {}", f));
        });
    }

    private WhatsAppCampaignModel buildCampaign(WhatsAppTemplateRequest request) {
        ArrayList components = new ArrayList();
        Optional.ofNullable(request.generarHeaderComponent(request.getHeader())).ifPresent(components::add);
        Optional.ofNullable(request.generarBodyComponent(request.getBody())).ifPresent(components::add);
        Optional.ofNullable(request.generarButtonComponents(request.getButtons())).filter(buttons -> !buttons.isEmpty()).ifPresent(components::addAll);
        TemplateWhatsApp template = new TemplateWhatsApp(request.getTemplateName(), components, request.getLanguage());
        String phoneNumber = PhoneNumberUtil.validatePhoneNumber((String)request.getNumber());
        return new WhatsAppCampaignModel(phoneNumber, template);
    }

    public TemplateMessageSenderService(CampaignService campaignService, ApiWhatsAppService whatsAppService, MessageStateCacheService messageStateCacheService, RelationCampaignStated relationCampaignStated, RelationCampaignHistory relationCampaignHistory, CampaignDetailRepository campaignDetailRepository, BusinessPhoneService businessPhoneService, CampaignStatedRepository campaignStatedRepository, ClientCacheService clientCacheService, ClientRepository clientRepository) {
        this.campaignService = campaignService;
        this.whatsAppService = whatsAppService;
        this.messageStateCacheService = messageStateCacheService;
        this.relationCampaignStated = relationCampaignStated;
        this.relationCampaignHistory = relationCampaignHistory;
        this.campaignDetailRepository = campaignDetailRepository;
        this.businessPhoneService = businessPhoneService;
        this.campaignStatedRepository = campaignStatedRepository;
        this.clientCacheService = clientCacheService;
        this.clientRepository = clientRepository;
    }
}

