/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.campaign.cache.ClientCacheService;
import com.whatsapp.campaign.cache.PhoneBuisnesIdCacheService;
import com.whatsapp.campaign.cache.RelationCampaignHistory;
import com.whatsapp.campaign.cache.RelationCampaignStated;
import com.whatsapp.campaign.data.UserResponse;
import com.whatsapp.campaign.entity.CampaignStated;
import com.whatsapp.campaign.entity.Client;
import com.whatsapp.campaign.entity.HistoryMessage;
import com.whatsapp.campaign.repository.BusinessPhoneRepository;
import com.whatsapp.campaign.repository.CampaignDetailRepository;
import com.whatsapp.campaign.repository.CampaignStatedRepository;
import com.whatsapp.campaign.repository.ClientRepository;
import com.whatsapp.campaign.repository.HistoryMessageRepository;
import com.whatsapp.campaign.service.ThinkAgentService;
import com.whatsapp.campaign.service.WebhookService;
import com.whatsapp.campaign.utils.ResponseUtil;
import com.whatsapp.campaign.utils.ResponseUtilStated;
import java.time.LocalDateTime;
import java.util.List;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class WebhookServiceImpl
implements WebhookService {
    private static final Logger log = LoggerFactory.getLogger(WebhookServiceImpl.class);
    private final ThinkAgentService thinkAgentService;
    private final ObjectMapper objectMapper;
    private final ResponseUtil responseUtil;
    private final ResponseUtilStated responseUtilStated;
    private final CampaignStatedRepository campaignStatedRepository;
    private final RelationCampaignStated relationCampaignStated;
    private final RelationCampaignHistory relationCampaignHistory;
    private final HistoryMessageRepository historyMessageRepository;
    private final CampaignDetailRepository campaignDetailRepository;
    private final ClientRepository clientRepository;
    private final ClientCacheService clientCacheService;
    private final PhoneBuisnesIdCacheService phone_business_id;
    private final BusinessPhoneRepository businessPhoneRepository;

    public Mono<ResponseEntity<?>> handleWebhook(Object userResponse) {
        log.info("\ud83d\udce5 Evento recibido por webhook (THINKAGENT)");
        return this.convertToUserResponse(userResponse).flatMap(userBody -> {
            log.info("object webhook: {}", userBody);
            List statuses = this.responseUtilStated.getStatuses(userBody);
            log.info("wamid: {}", (Object)statuses);
            return Flux.fromIterable((Iterable)statuses).flatMap(status -> this.relationCampaignStated.getData(status.getMessageId()).flatMap(idCampaignStr -> {
                Long idCampaign = Long.valueOf(idCampaignStr);
                Mono campaignStated = this.campaignDetailRepository.updateStatedCampaignById(idCampaign, status.getMessage());
                Mono updateDelivered = "delivered".equals(status.getMessage()) || "read".equals(status.getMessage()) ? this.campaignDetailRepository.updateDeliveredById(idCampaign, Boolean.valueOf(true)) : Mono.empty();
                CampaignStated c_stated = new CampaignStated();
                c_stated.setStateType(status.getMessage());
                c_stated.setCampaignId(idCampaign);
                log.info("\ud83d\udcca Guardando estado: {} para campa\u00f1a ID: {}", (Object)status.getMessage(), (Object)idCampaign);
                return this.campaignStatedRepository.save((Object)c_stated).then(updateDelivered).then(campaignStated).then("read".equals(status.getMessage()) ? this.relationCampaignStated.delete(status.getMessageId()).then(Mono.empty()) : Mono.empty());
            })).then(this.responseUtil.getMessage(userBody).flatMap(body -> this.thinkAgentService.sendMessageToTAS(body).flatMap(res -> {
                log.info("body webhook tem: {}", body);
                log.info("THINKAGENT RESPONSE {}", res);
                HistoryMessage historyMessage = new HistoryMessage();
                historyMessage.setPhoneId(body.getIdConversation());
                historyMessage.setNick(body.getNick());
                historyMessage.setMessage(body.getMessage());
                historyMessage.setType(body.getType());
                historyMessage.setRol("USER");
                historyMessage.setMessageTypeMode("THINKAGENT");
                Mono clientMono = this.clientCacheService.exists(body.getIdConversation()).flatMap(exists -> {
                    if (exists.booleanValue()) {
                        return this.clientCacheService.getData(body.getIdConversation()).flatMap(data -> this.clientRepository.updateCreatedAtById(Long.valueOf(data), LocalDateTime.now())).then();
                    }
                    return this.clientRepository.findByNumberphone(body.getIdConversation()).flatMap(cl -> this.clientCacheService.setData(cl.getNumberphone(), String.valueOf(cl.getId())).doOnNext(cache -> log.info("\ud83d\udce6 Cliente cacheado: {}", cl)).then()).switchIfEmpty(Mono.defer(() -> this.phone_business_id.getPhoneIdByPhoneIdentifier(body.getBusinessAccountId()).flatMap(phoneIdFromCache -> {
                        Client cli = new Client();
                        cli.setUserName(body.getNick());
                        cli.setNumberphone(body.getIdConversation());
                        cli.setStateActive(Boolean.valueOf(true));
                        cli.setBusinessPhoneId(phoneIdFromCache);
                        return this.clientRepository.save((Object)cli).flatMap(c -> this.clientCacheService.setData(body.getIdConversation(), String.valueOf(c.getId()))).doOnNext(cache -> log.info("\ud83c\udd95 Cliente creado y cacheado: {}", (Object)cli)).then();
                    }).switchIfEmpty(this.businessPhoneRepository.findByPhoneBusinessId(body.getBusinessAccountId()).flatMap(ph -> {
                        Client cli = new Client();
                        cli.setUserName(body.getNick());
                        cli.setNumberphone(body.getIdConversation());
                        cli.setStateActive(Boolean.valueOf(true));
                        cli.setBusinessPhoneId(ph.getId());
                        this.phone_business_id.setPhoneId(body.getBusinessAccountId(), ph.getId());
                        return this.clientRepository.save((Object)cli).flatMap(c -> this.clientCacheService.setData(body.getIdConversation(), String.valueOf(c.getId()))).doOnNext(cache -> log.info("\ud83c\udd95 Cliente creado y cacheado: {}", (Object)cli)).then();
                    }))));
                });
                Mono cacheMono = this.clientRepository.findByNumberphone(body.getIdConversation()).flatMap(cl -> {
                    this.clientCacheService.setData(cl.getNumberphone(), String.valueOf(cl.getId()));
                    log.info("\ud83d\udce6 Cliente cacheado: {}", cl);
                    return Mono.empty();
                });
                Mono historyMono = this.relationCampaignHistory.exists(body.getIdConversation()).flatMap(exists -> {
                    if (exists.booleanValue()) {
                        return this.relationCampaignHistory.getData(body.getIdConversation()).flatMap(data -> {
                            historyMessage.setCampaignId(Long.valueOf(data));
                            return this.historyMessageRepository.save((Object)historyMessage);
                        });
                    }
                    return this.historyMessageRepository.save((Object)historyMessage);
                }).then();
                return Mono.when((Publisher[])new Publisher[]{clientMono, cacheMono, historyMono}).thenReturn((Object)ResponseEntity.ok().build());
            })));
        });
    }

    private Mono<UserResponse> convertToUserResponse(Object userResponse) {
        try {
            String json = this.objectMapper.writeValueAsString(userResponse);
            UserResponse userBody = (UserResponse)this.objectMapper.readValue(json, UserResponse.class);
            return Mono.just((Object)userBody);
        }
        catch (Exception e) {
            log.error("\u274c Error al convertir userResponse: ", (Throwable)e);
            return Mono.error((Throwable)new RuntimeException("Formato inv\u00e1lido en el webhook"));
        }
    }

    public WebhookServiceImpl(ThinkAgentService thinkAgentService, ObjectMapper objectMapper, ResponseUtil responseUtil, ResponseUtilStated responseUtilStated, CampaignStatedRepository campaignStatedRepository, RelationCampaignStated relationCampaignStated, RelationCampaignHistory relationCampaignHistory, HistoryMessageRepository historyMessageRepository, CampaignDetailRepository campaignDetailRepository, ClientRepository clientRepository, ClientCacheService clientCacheService, PhoneBuisnesIdCacheService phone_business_id, BusinessPhoneRepository businessPhoneRepository) {
        this.thinkAgentService = thinkAgentService;
        this.objectMapper = objectMapper;
        this.responseUtil = responseUtil;
        this.responseUtilStated = responseUtilStated;
        this.campaignStatedRepository = campaignStatedRepository;
        this.relationCampaignStated = relationCampaignStated;
        this.relationCampaignHistory = relationCampaignHistory;
        this.historyMessageRepository = historyMessageRepository;
        this.campaignDetailRepository = campaignDetailRepository;
        this.clientRepository = clientRepository;
        this.clientCacheService = clientCacheService;
        this.phone_business_id = phone_business_id;
        this.businessPhoneRepository = businessPhoneRepository;
    }
}

