/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.whatsapp.campaign.cache.RelationCampaignHistory;
import com.whatsapp.campaign.cache.RelationCampaignStated;
import com.whatsapp.campaign.client.tsa.TsaApiService;
import com.whatsapp.campaign.client.tsa.models.ResponseMessageEvent;
import com.whatsapp.campaign.client.whatsapp.models.FileMessageRequest;
import com.whatsapp.campaign.client.whatsapp.models.TextMessageRequest;
import com.whatsapp.campaign.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.campaign.data.ExtractData;
import com.whatsapp.campaign.data.tsa.RequestMessageModel;
import com.whatsapp.campaign.entity.HistoryMessage;
import com.whatsapp.campaign.repository.HistoryMessageRepository;
import com.whatsapp.campaign.service.ThinkAgentService;
import com.whatsapp.campaign.utils.MessageTypeUtils;
import com.whatsapp.campaign.utils.TemplateTsaMessages;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ThinkAgentServiceImpl
implements ThinkAgentService {
    private static final Logger log = LoggerFactory.getLogger(ThinkAgentServiceImpl.class);
    private final TsaApiService tsaApiService;
    private final ApiWhatsAppService whatsAppService;
    private final RelationCampaignStated relationCampaignStated;
    private final RelationCampaignHistory relationCampaignHistory;
    private final HistoryMessageRepository historyMessageRepository;
    private final Environment env;

    public Mono<ResponseEntity<?>> sendMessageToWhatsappFromTSA(RequestMessageModel requestMessageModel) {
        return this.processMessageToTsa(requestMessageModel).flatMap(response -> {
            log.info("response webhook {}", response);
            return Mono.just((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent"));
        });
    }

    private Mono<ResponseEntity<String>> processMessageToTsa(RequestMessageModel requestMessageModel) {
        Mono messageFlowMono;
        log.info("Request Think Agent: {}", (Object)requestMessageModel);
        Mono saveMessageMono = this.relationCampaignHistory.exists(requestMessageModel.getId()).flatMap(exists -> {
            HistoryMessage historyMessage = new HistoryMessage();
            historyMessage.setPhoneId(requestMessageModel.getId());
            historyMessage.setNick(requestMessageModel.getNick());
            historyMessage.setMessage(requestMessageModel.getPayload().getContent());
            historyMessage.setType(requestMessageModel.getPayload().getType());
            historyMessage.setRol("TSA");
            historyMessage.setMessageTypeMode("THINKAGENT");
            if (exists.booleanValue()) {
                return this.relationCampaignHistory.getData(requestMessageModel.getId()).flatMap(data -> {
                    historyMessage.setCampaignId(Long.valueOf(data));
                    return this.historyMessageRepository.save((Object)historyMessage);
                });
            }
            return this.historyMessageRepository.save((Object)historyMessage);
        });
        switch (requestMessageModel.getPayload().getType()) {
            case "text": {
                TextMessageRequest textMessage = new TextMessageRequest(requestMessageModel.getId(), requestMessageModel.getPayload().getContent());
                if (textMessage.getMessage().toUpperCase().contains("ESTE MENSAJE SE HA ELIMINADO")) {
                    log.info("Mensaje de eliminaci\u00f3n ignorado");
                    return saveMessageMono.thenReturn((Object)ResponseEntity.ok((Object)UUID.randomUUID().toString()));
                }
                Mono cleanupMono = Mono.empty();
                if (textMessage.getMessage().toUpperCase().contains("POR FAVOR CALIFICA ESTA CONVERSACI")) {
                    log.info("eliminacion de registros redis");
                    cleanupMono = this.relationCampaignHistory.getData(requestMessageModel.getId()).flatMap(id -> this.relationCampaignHistory.delete(requestMessageModel.getId()).then(this.relationCampaignStated.deleteByValue(id))).then(Mono.empty());
                }
                messageFlowMono = cleanupMono.then(this.whatsAppService.sendTextMessage(textMessage));
                break;
            }
            case "image": {
                log.info("Enviando imagen...");
                FileMessageRequest imageFileRequest = new FileMessageRequest(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                messageFlowMono = this.whatsAppService.sendImageMessage(imageFileRequest);
                break;
            }
            case "video": {
                log.info("Enviando video...");
                FileMessageRequest videoFileRequest = new FileMessageRequest(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                messageFlowMono = this.whatsAppService.sendVideoMessage(videoFileRequest);
                break;
            }
            case "document": {
                log.info("Enviando documento...");
                FileMessageRequest documentFileRequest = new FileMessageRequest(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                messageFlowMono = this.whatsAppService.sendDocumentMessage(documentFileRequest);
                break;
            }
            case "audio": {
                log.info("Enviando audio...");
                FileMessageRequest audioFileRequest = new FileMessageRequest(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                messageFlowMono = this.whatsAppService.sendAudioMessage(audioFileRequest);
                break;
            }
            default: {
                log.info("Tipo desconocido, enviando como texto...");
                TextMessageRequest unknownTextMessage = new TextMessageRequest(requestMessageModel.getId(), requestMessageModel.getPayload().getContent());
                messageFlowMono = this.whatsAppService.sendTextMessage(unknownTextMessage);
            }
        }
        return saveMessageMono.then(messageFlowMono);
    }

    public Mono<ResponseEntity<String>> sendMessageToTAS(ExtractData dataMessageMeta) {
        log.info("Data message meta: {}", (Object)dataMessageMeta);
        String defaultCallback = this.env.getProperty("tsa.canal.callback.default");
        RequestMessageModel requestMessageModel = new RequestMessageModel();
        RequestMessageModel.Payload payload = new RequestMessageModel.Payload();
        if (dataMessageMeta.getType().equalsIgnoreCase(MessageTypeUtils.TYPE_LOCATION)) {
            payload.setType(MessageTypeUtils.TYPE_TEXT);
            payload.setContent(TemplateTsaMessages.TEMPLATE_MD_LOCATION.replace("{lat}", dataMessageMeta.getLatitude()).replace("{lon}", dataMessageMeta.getLongitude()));
        } else if (dataMessageMeta.getType().equals(MessageTypeUtils.TYPE_TEXT)) {
            payload.setType(dataMessageMeta.getType());
            payload.setContent(dataMessageMeta.getMessage());
        } else {
            if (dataMessageMeta.getFile() == null) {
                log.warn("TIPO DE DATO NO IDENTIFICADO O SOPORTADO, PROCEDE A IGNORAR");
                return Mono.just((Object)ResponseEntity.ok((Object)"mensaje aceptado"));
            }
            payload.setType(MessageTypeUtils.TYPE_FILE);
            payload.setContent(dataMessageMeta.getFile());
        }
        requestMessageModel.setType("message");
        requestMessageModel.setId(dataMessageMeta.getIdConversation());
        requestMessageModel.setPayload(payload);
        requestMessageModel.setChannel("whatsapp");
        requestMessageModel.setNick(dataMessageMeta.getNick());
        if (dataMessageMeta.getReplyMessageId() != null) {
            requestMessageModel.getPayload().setRepliedMessage("Replied message content");
        }
        return this.sendMessageToTAS(requestMessageModel, defaultCallback).map(response -> ResponseEntity.ok((Object)"Message sent to ThinkAgent"));
    }

    private Mono<ResponseEntity<ResponseMessageEvent>> sendMessageToTAS(RequestMessageModel requestMessageModel, String callbackId) {
        return this.tsaApiService.sendMesssageToAsesor(requestMessageModel, callbackId).map(response -> ResponseEntity.ok((Object)response));
    }

    public ThinkAgentServiceImpl(TsaApiService tsaApiService, ApiWhatsAppService whatsAppService, RelationCampaignStated relationCampaignStated, RelationCampaignHistory relationCampaignHistory, HistoryMessageRepository historyMessageRepository, Environment env) {
        this.tsaApiService = tsaApiService;
        this.whatsAppService = whatsAppService;
        this.relationCampaignStated = relationCampaignStated;
        this.relationCampaignHistory = relationCampaignHistory;
        this.historyMessageRepository = historyMessageRepository;
        this.env = env;
    }
}

