/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.whatsapp.campaign.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.campaign.data.CampaignDataRequest;
import com.whatsapp.campaign.data.ConversationSummaryResponse;
import com.whatsapp.campaign.data.TemplateData;
import com.whatsapp.campaign.data.WhatsAppTemplate;
import com.whatsapp.campaign.dto.image.ImagenModelDTO;
import com.whatsapp.campaign.entity.TImage;
import com.whatsapp.campaign.exceptions.CustomException;
import com.whatsapp.campaign.repository.ImageRepository;
import com.whatsapp.campaign.service.TemplateService;
import com.whatsapp.campaign.service.sender.TemplateMessageSenderService;
import com.whatsapp.campaign.utils.TemplateBatchBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    private final ImageRepository imageRepository;
    private final ApiWhatsAppService whatsAppService;
    private final TemplateMessageSenderService templateMessageSenderService;

    public Mono<List<WhatsAppTemplate>> getTemplates() {
        log.info("FILTER ALL TEMPLATES");
        return this.whatsAppService.getTemplates().flatMap(data -> {
            try {
                ArrayList<WhatsAppTemplate> templates = new ArrayList<WhatsAppTemplate>();
                if (data == null || data.getData() == null) {
                    return Mono.just(templates);
                }
                for (TemplateData.Template templateNode : data.getData()) {
                    WhatsAppTemplate template = new WhatsAppTemplate();
                    template.setName(templateNode.getName());
                    template.setLanguage(templateNode.getLanguage());
                    template.setStatus(templateNode.getStatus());
                    template.setCategory(templateNode.getCategory());
                    template.setId(templateNode.getId());
                    ArrayList<WhatsAppTemplate.Component> components = new ArrayList<WhatsAppTemplate.Component>();
                    for (TemplateData.Component componentNode : templateNode.getComponents()) {
                        WhatsAppTemplate.Component component = new WhatsAppTemplate.Component();
                        component.setType(componentNode.getType());
                        component.setText(componentNode.getText());
                        component.setFormat(componentNode.getFormat());
                        components.add(component);
                    }
                    template.setComponents(components);
                    templates.add(template);
                }
                return Mono.just(templates);
            }
            catch (Exception e) {
                log.error("Error parsing templates", (Throwable)e);
                return Mono.error((Throwable)new RuntimeException("Error parsing templates"));
            }
        });
    }

    public Mono<WhatsAppTemplate> getTemplateById(String id) {
        Mono monoTemplate = this.getTemplates().flatMapMany(Flux::fromIterable).filter(template -> template.getId().equals(id)).next().switchIfEmpty(Mono.error((Throwable)new CustomException("Plantilla no encontrada", HttpStatus.NOT_FOUND))).onErrorResume(err -> {
            log.error("Error retrieving template by ID: {}, Err:{}", (Object)id, err);
            return Mono.error((Throwable)new CustomException("Ocurri\u00f3 un error al obtener la plantilla", HttpStatus.BAD_REQUEST));
        });
        return monoTemplate.flatMap(tem -> this.obtenerIdImagen(tem.getId()).flatMap(imgUrl -> {
            tem.setFileUrl(imgUrl);
            return Mono.just((Object)tem);
        }).onErrorResume(err -> Mono.just((Object)tem)));
    }

    public Mono<ConversationSummaryResponse> getConversationSummary(Date fecha_inicio, Date fecha_fin) {
        return this.whatsAppService.getConversationSummary(fecha_inicio, fecha_fin);
    }

    public Mono<ImagenModelDTO> guardarUrlImagen(String id, String url) {
        TImage image = TImage.builder().imageId(id).imageUrl(url).build();
        ImagenModelDTO imageDto = ImagenModelDTO.builder().idImagen(id).urlImagen(url).build();
        return this.imageRepository.findByImageId(id).switchIfEmpty(this.imageRepository.save((Object)image)).flatMap(existingImage -> {
            existingImage.setImageUrl(url);
            return this.imageRepository.save(existingImage);
        }).thenReturn((Object)imageDto).onErrorResume(err -> Mono.error((Throwable)new CustomException("Error saving image URL: " + err.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR)));
    }

    public Mono<String> obtenerIdImagen(String id) {
        return this.imageRepository.findImageUrlByImageId(id).switchIfEmpty(Mono.error((Throwable)new CustomException("Im\u00e1gen no encontrada", HttpStatus.NOT_FOUND)));
    }

    public Mono<String> sendTemplateBatch(CampaignDataRequest request) {
        String userName = request.getUserName();
        List listWhatsAppTemplateRequest = TemplateBatchBuilder.buildFromCampaignRequest((CampaignDataRequest)request);
        return this.templateMessageSenderService.sendMessageFromTemplateListItem(listWhatsAppTemplateRequest, userName);
    }

    public TemplateServiceImpl(ImageRepository imageRepository, ApiWhatsAppService whatsAppService, TemplateMessageSenderService templateMessageSenderService) {
        this.imageRepository = imageRepository;
        this.whatsAppService = whatsAppService;
        this.templateMessageSenderService = templateMessageSenderService;
    }
}

