/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.whatsapp.campaign.cache.MessageStateCacheService;
import com.whatsapp.campaign.data.StatusMessageRequest;
import com.whatsapp.campaign.repository.CampaignDetailRepository;
import com.whatsapp.campaign.service.StatusMessageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class StatusMessageServiceImpl
implements StatusMessageService {
    private static final Logger log = LoggerFactory.getLogger(StatusMessageServiceImpl.class);
    private final CampaignDetailRepository campaignDetailRepository;
    private final MessageStateCacheService messageStateCacheService;

    public Mono<ResponseEntity<Void>> updateStatusMessage(StatusMessageRequest request) {
        log.info("Iniciando actualizaci\u00f3n de estados de mensajes. Total de entradas: {}", (Object)request.getEntry().size());
        return Flux.fromIterable((Iterable)request.getEntry()).flatMap(entry -> Flux.fromIterable((Iterable)entry.getChanges())).filter(change -> change.getValue().getStatuses() != null).flatMap(change -> Flux.fromIterable((Iterable)change.getValue().getStatuses())).flatMap(status -> {
            String messageId = status.getId();
            String messageStatus = status.getStatus();
            log.info("Procesando estado para messageId: {}, nuevo estado: {}", (Object)messageId, (Object)messageStatus);
            return this.messageStateCacheService.exists(messageId).doOnNext(exists -> {
                if (exists.booleanValue()) {
                    log.info("El messageId: {} existe en Redis", (Object)messageId);
                } else {
                    log.warn("El messageId: {} NO existe en Redis", (Object)messageId);
                }
            }).filter(Boolean::booleanValue).flatMap(exists -> this.campaignDetailRepository.findByMessageId(messageId).flatMap(data -> {
                data.setMessageStatus(messageStatus);
                if (status.getErrors() != null && !status.getErrors().isEmpty()) {
                    String errorMessage = ((StatusMessageRequest.Error)status.getErrors().get(0)).getMessage();
                    data.setMessageError(errorMessage);
                    log.warn("Se detect\u00f3 error en el mensaje {}: {}", (Object)messageId, (Object)errorMessage);
                } else {
                    data.setMessageError("");
                }
                log.debug("Actualizando estado del mensaje en base de datos. messageId: {}, status: {}", (Object)messageId, (Object)messageStatus);
                return this.campaignDetailRepository.save(data).doOnSuccess(updated -> log.info("Estado actualizado exitosamente para messageId: {}", (Object)messageId));
            }).doOnError(e -> log.error("Error al actualizar estado del mensaje {}: {}", new Object[]{messageId, e.getMessage(), e})));
        }).doOnComplete(() -> log.info("Finaliz\u00f3 la actualizaci\u00f3n de estados de mensajes.")).doOnError(error -> log.error("Error inesperado en el flujo de actualizaci\u00f3n de mensajes: {}", (Object)error.getMessage(), error)).then(Mono.just((Object)ResponseEntity.ok().build()));
    }

    public StatusMessageServiceImpl(CampaignDetailRepository campaignDetailRepository, MessageStateCacheService messageStateCacheService) {
        this.campaignDetailRepository = campaignDetailRepository;
        this.messageStateCacheService = messageStateCacheService;
    }
}

