/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.whatsapp.campaign.data.PagedResponse;
import com.whatsapp.campaign.entity.Client;
import com.whatsapp.campaign.entity.VwReportHistoryMessage;
import com.whatsapp.campaign.repository.ClientRepository;
import com.whatsapp.campaign.repository.VwReportHistoryMessageRepository;
import com.whatsapp.campaign.service.HistoryService;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class HistoryServiceImpl
implements HistoryService {
    private static final Logger log = LoggerFactory.getLogger(HistoryServiceImpl.class);
    private final ClientRepository clientRepository;
    private final VwReportHistoryMessageRepository historyMessageRepository;

    public Mono<PagedResponse<Client>> getHistoryConversations(int page, int size, String sortDirection, String filterValue) {
        long offset = (long)page * (long)size;
        String filter = filterValue != null && !filterValue.isEmpty() && !filterValue.equalsIgnoreCase("undefined") ? filterValue : "";
        return this.clientRepository.countFiltered(filter).flatMap(totalElements -> {
            int totalPages = (int)Math.ceil((double)totalElements.longValue() / (double)size);
            boolean isLast = page + 1 >= totalPages;
            return this.clientRepository.findFiltered(filter, size, offset).collectList().map(content -> new PagedResponse(content, page, size, totalElements.longValue(), totalPages, isLast));
        });
    }

    public Mono<PagedResponse<VwReportHistoryMessage>> getCampaigReportHistoryMessage(int page, int size, String sortDirection, String idPlatform) {
        int offset = page * size;
        Mono itemsMono = this.historyMessageRepository.findByHistoryMessageAtBetween(idPlatform, size, offset).collectList();
        Mono totalMono = this.historyMessageRepository.countByHistoryMessageBetween(idPlatform);
        return Mono.zip((Mono)itemsMono, (Mono)totalMono).map(tuple -> {
            List content = (List)tuple.getT1();
            Long totalElements = (Long)tuple.getT2();
            int totalPages = (int)Math.ceil((double)totalElements.longValue() / (double)size);
            boolean last = page + 1 >= totalPages;
            return new PagedResponse(content, page, size, totalElements.longValue(), totalPages, last);
        });
    }

    public LocalDateTime transformarFecha(LocalDateTime dateTime) {
        return dateTime.withSecond(0).withNano(0);
    }

    public HistoryServiceImpl(ClientRepository clientRepository, VwReportHistoryMessageRepository historyMessageRepository) {
        this.clientRepository = clientRepository;
        this.historyMessageRepository = historyMessageRepository;
    }
}

