/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.whatsapp.campaign.data.CampaignExportForm;
import com.whatsapp.campaign.data.CampaignSearchRequest;
import com.whatsapp.campaign.data.PagedResponse;
import com.whatsapp.campaign.dto.DailyCountDTO;
import com.whatsapp.campaign.dto.ErrorCampaignDetail;
import com.whatsapp.campaign.dto.ReportCampaignStatuses;
import com.whatsapp.campaign.dto.request.DateRequests;
import com.whatsapp.campaign.entity.TCampaign;
import com.whatsapp.campaign.entity.VwReportCampaignStated;
import com.whatsapp.campaign.repository.CampaignDetailRepository;
import com.whatsapp.campaign.repository.CampaignRepository;
import com.whatsapp.campaign.service.CampaignService;
import com.whatsapp.campaign.utils.DateUtils;
import com.whatsapp.campaign.utils.StatusLabelUtil;
import com.whatsapp.campaign.utils.Utils;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ContentDisposition;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class CampaignServiceImpl
implements CampaignService {
    private static final Logger log = LoggerFactory.getLogger(CampaignServiceImpl.class);
    private final CampaignRepository campaignRepository;
    private final CampaignDetailRepository campaignDetailRepository;

    public Mono<TCampaign> saveCampaignHeader(TCampaign headerCamapaign) {
        headerCamapaign.setCreatedAt(LocalDateTime.now());
        return this.campaignRepository.save((Object)headerCamapaign);
    }

    public Mono<List<ErrorCampaignDetail>> filterNumbersWithError(List<String> conversationIds) {
        if (conversationIds == null || conversationIds.isEmpty()) {
            throw new IllegalArgumentException("La lista de conversationIds no puede ser nula o vac\u00eda.");
        }
        return this.campaignDetailRepository.filterNumbersWithError(conversationIds).collectList();
    }

    public Mono<List<ReportCampaignStatuses>> obtenerListaEstadisticasPorEstadoCampana(DateRequests request) {
        if (request.getStartDate() == null || request.getEndDate() == null) {
            throw new IllegalArgumentException("Las fechas no pueden ser nulas.");
        }
        LocalDateTime startDate = DateUtils.convertToLocalDateTimeStart((LocalDate)request.getStartDate());
        LocalDateTime endDate = DateUtils.convertToLocalDateTimeEnd((LocalDate)request.getEndDate());
        return this.campaignDetailRepository.getMessageStatusCounts(startDate, endDate).collectList();
    }

    public Mono<List<DailyCountDTO>> obtenerListaDeCompanasPorFecha(LocalDate inicio, LocalDate fin) {
        LocalDateTime startDate = DateUtils.convertToLocalDateTimeStart((LocalDate)inicio);
        LocalDateTime endDate = DateUtils.convertToLocalDateTimeEnd((LocalDate)fin);
        return this.campaignDetailRepository.getDailyCounts(startDate, endDate).collectList().map(lista -> Utils.completarDiasFaltantes((List)lista, (LocalDate)inicio, (LocalDate)fin));
    }

    public Mono<PagedResponse<VwReportCampaignStated>> getCampaigReportStated(CampaignSearchRequest request) {
        log.info("fechas: {}   {}", (Object)this.transformarFecha(request.getStartDate()), (Object)this.transformarFecha(request.getEndDate()));
        int page = request.getPage();
        int size = request.getSize();
        int offset = page * size;
        Mono itemsMono = this.campaignDetailRepository.findByCampaignCreatedAtBetween(this.transformarFecha(request.getStartDate()), this.transformarFecha(request.getEndDate()), size, offset).collectList();
        Mono totalMono = this.campaignDetailRepository.countByCampaignCreatedAtBetween(this.transformarFecha(request.getStartDate()), this.transformarFecha(request.getEndDate()));
        return Mono.zip((Mono)itemsMono, (Mono)totalMono).map(tuple -> {
            List content = (List)tuple.getT1();
            Long totalElements = (Long)tuple.getT2();
            int totalPages = (int)Math.ceil((double)totalElements.longValue() / (double)size);
            boolean last = page + 1 >= totalPages;
            return new PagedResponse(content, page, size, totalElements.longValue(), totalPages, last);
        });
    }

    public Mono<Void> exportCampaigns(CampaignExportForm form, ServerHttpResponse response) {
        Long campaignHeaderId = form.getCampaignHeaderId();
        response.getHeaders().setContentDisposition(ContentDisposition.attachment().filename("campaign_report.csv").build());
        response.getHeaders().setContentType(MediaType.TEXT_PLAIN);
        String header = "CampaignId,TemplateName,Category,User,CampaignCreatedAt,PhoneId,StateType,StateCreatedAt\n";
        Flux csvContent = this.campaignDetailRepository.exportReportStatedCsv(campaignHeaderId).doOnNext(cam -> log.info("cam : {}", cam)).map(row -> String.format("%d,%s,%s,%s,%s,%d,%s,%s\n", row.getCampaignId(), row.getTemplateName(), row.getCategoryName(), row.getUserName(), StatusLabelUtil.formatLocalDateTimeEcuador((LocalDateTime)row.getCampaignCreatedAt()), row.getPhoneId(), row.getStateType(), StatusLabelUtil.formatLocalDateTimeEcuador((LocalDateTime)row.getStateCreatedAt()))).startWith((Object[])new String[]{header}).map(line -> response.bufferFactory().wrap(line.getBytes(StandardCharsets.UTF_8)));
        return response.writeWith((Publisher)csvContent);
    }

    public LocalDateTime transformarFecha(LocalDateTime dateTime) {
        return dateTime.withSecond(0).withNano(0);
    }

    public CampaignServiceImpl(CampaignRepository campaignRepository, CampaignDetailRepository campaignDetailRepository) {
        this.campaignRepository = campaignRepository;
        this.campaignDetailRepository = campaignDetailRepository;
    }
}

