/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.whatsapp.campaign.cache.PhoneCacheService;
import com.whatsapp.campaign.dto.phone.AutoRegisterDTO;
import com.whatsapp.campaign.dto.phone.BusinessPhoneDTO;
import com.whatsapp.campaign.entity.TBusinessPhone;
import com.whatsapp.campaign.exceptions.CustomException;
import com.whatsapp.campaign.repository.BusinessPhoneRepository;
import com.whatsapp.campaign.service.BusinessPhoneService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class BusinessPhoneServiceImpl
implements BusinessPhoneService {
    private static final Logger log = LoggerFactory.getLogger(BusinessPhoneServiceImpl.class);
    private final BusinessPhoneRepository businessPhoneRepository;
    private final AutoRegisterDTO props;
    private final PhoneCacheService phoneCacheService;
    private final Environment environment;

    public Mono<BusinessPhoneDTO> getStateServer4notify(Boolean state) {
        String phoneId = this.environment.getProperty("whatsapp.phone.id");
        String basePath = this.environment.getProperty("spring.webflux.base-path");
        return this.businessPhoneRepository.getStateServer4notify(phoneId).flatMap(phone -> {
            phone.setOnline(state);
            phone.setBasePath(basePath);
            log.info("Retrieved phone from DB: {}", phone);
            return Mono.just((Object)phone);
        }).switchIfEmpty(this.registerPhoneIfNotExists(phoneId).flatMap(phone -> {
            phone.setOnline(state);
            phone.setBasePath(basePath);
            log.info("Registered new phone: {}", phone);
            return Mono.just((Object)phone);
        }));
    }

    private Mono<BusinessPhoneDTO> registerPhoneIfNotExists(String phoneId) {
        TBusinessPhone businessPhone = TBusinessPhone.builder().phoneId(this.props.getPhoneNumberId()).phoneName(this.props.getPhoneName()).description(this.props.getDescription()).phoneNumber(this.props.getPhoneNumber()).phoneBusinessId(this.props.getPhoneBusinessId()).active(Boolean.valueOf(this.props.isActive())).build();
        return this.businessPhoneRepository.findByPhoneId(phoneId).switchIfEmpty(this.businessPhoneRepository.save((Object)businessPhone).flatMap(savedPhone -> {
            log.info("Registered new phone: {}", savedPhone);
            return Mono.just((Object)savedPhone);
        })).flatMap(phone -> {
            log.info("Found or registered phone: {}", phone);
            return this.businessPhoneRepository.getStateServer4notify(phone.getPhoneId());
        });
    }

    public Mono<Long> findIdByPhoneId() {
        String phoneId = this.environment.getProperty("whatsapp.phone.id");
        return this.phoneCacheService.getPhoneIdByPhoneIdentifier(phoneId).switchIfEmpty(this.businessPhoneRepository.findIdByPhoneId(phoneId).flatMap(phoneIdDb -> {
            log.info("Phone ID from DB: {}", phoneIdDb);
            return this.phoneCacheService.setPhoneId(phoneId, phoneIdDb).flatMap(success -> {
                if (success.booleanValue()) {
                    log.info("Phone ID cached successfully: {}", phoneIdDb);
                } else {
                    log.warn("Failed to cache Phone ID: {}", phoneIdDb);
                }
                return Mono.just((Object)phoneIdDb);
            });
        }).switchIfEmpty(Mono.error((Throwable)new CustomException("No phone id matches ", HttpStatus.NOT_FOUND)))).flatMap(phoneCachedId -> {
            log.info("Phone ID from cache: {}", phoneCachedId);
            return Mono.just((Object)phoneCachedId);
        });
    }

    public BusinessPhoneServiceImpl(BusinessPhoneRepository businessPhoneRepository, AutoRegisterDTO props, PhoneCacheService phoneCacheService, Environment environment) {
        this.businessPhoneRepository = businessPhoneRepository;
        this.props = props;
        this.phoneCacheService = phoneCacheService;
        this.environment = environment;
    }
}

