/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.server;

import com.whatsapp.campaign.client.utils.WebClientUtils;
import com.whatsapp.campaign.dto.phone.BusinessPhoneDTO;
import com.whatsapp.campaign.service.BusinessPhoneService;
import jakarta.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class LifecycleService {
    private static final Logger log = LoggerFactory.getLogger(LifecycleService.class);
    private final BusinessPhoneService businessPhoneService;
    private final Environment environment;
    private final WebClient webClient;

    public LifecycleService(@Qualifier(value="whatsappWebClient") WebClient webClient, BusinessPhoneService businessPhoneService, Environment environment) {
        this.webClient = webClient;
        this.businessPhoneService = businessPhoneService;
        this.environment = environment;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void onStartup() {
        String STARTUP_URL = this.environment.getProperty("registration.notify.url");
        log.info("\ud83d\ude80 WebFlux - Startup event detectado. Enviando notificaci\u00f3n reactiva...");
        this.businessPhoneService.getStateServer4notify(Boolean.valueOf(true)).flatMap(payload -> this.sendNotification(STARTUP_URL, payload)).subscribe(ok -> log.info("\u2705 Notificaci\u00f3n de startup enviada"), err -> log.error("\u274c Error notificando en startup: {}", (Object)err.getMessage()));
    }

    @PreDestroy
    public void onShutdown() {
        String SHUTDOWN_URL = this.environment.getProperty("registration.notify.url");
        log.info("\u26d4 WebFlux - Shutdown detectado. Enviando notificaci\u00f3n reactiva...");
        try {
            this.businessPhoneService.getStateServer4notify(Boolean.valueOf(false)).flatMap(payload -> this.sendNotification(SHUTDOWN_URL, payload)).doOnSuccess(v -> log.info("\u2705 Notificaci\u00f3n de shutdown enviada")).doOnError(err -> log.error("\u274c Error notificando en shutdown: {}", (Object)err.getMessage())).block();
        }
        catch (Exception e) {
            log.error("\u274c Excepci\u00f3n al enviar notificaci\u00f3n en shutdown: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private Mono<Void> sendNotification(String url, BusinessPhoneDTO body) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        log.info("payload: {}", (Object)body);
        return WebClientUtils.handleWebClientResponse((WebClient.RequestHeadersSpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(url, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue((Object)body), Void.class, (String)"LifecycleService Notification").then();
    }
}

