/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.repository;

import com.whatsapp.campaign.dto.DailyCountDTO;
import com.whatsapp.campaign.dto.ErrorCampaignDetail;
import com.whatsapp.campaign.dto.ReportCampaignStatuses;
import com.whatsapp.campaign.dto.campaignDetail.CsvCampaignDetailDTO;
import com.whatsapp.campaign.entity.TCampaignDetail;
import com.whatsapp.campaign.entity.VwReportCampaignStated;
import io.lettuce.core.dynamic.annotation.Param;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.r2dbc.repository.Query;
import org.springframework.data.r2dbc.repository.R2dbcRepository;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface CampaignDetailRepository
extends R2dbcRepository<TCampaignDetail, Long> {
    public Mono<TCampaignDetail> findByMessageId(String var1);

    public Flux<TCampaignDetail> findByCampaignId(Long var1, Pageable var2);

    public Mono<Long> countByCampaignId(Long var1);

    @Query(value="SELECT tc.conversation_id, tc.message_status, tc.created_at, tc.message_error FROM t_campaign_detail tc WHERE tc.campaign_id = :campaignHeaderId")
    public Flux<CsvCampaignDetailDTO> getByCampaignId(Long var1);

    @Query(value="SELECT TO_CHAR(created_at, 'YYYY-MM-DD') AS date, COUNT(*) AS total FROM t_campaign_detail WHERE created_at >= CAST(:initDate AS TIMESTAMP) AND created_at <= CAST(:endDate AS TIMESTAMP) GROUP BY TO_CHAR(created_at, 'YYYY-MM-DD') ORDER BY date ASC")
    public Flux<DailyCountDTO> getDailyCounts(LocalDateTime var1, LocalDateTime var2);

    @Query(value="SELECT message_status, COUNT(*) AS count FROM t_campaign_detail WHERE created_at >= :startDate AND created_at <= :endDate AND message_status IS NOT NULL GROUP BY message_status ORDER BY message_status")
    public Flux<ReportCampaignStatuses> getMessageStatusCounts(LocalDateTime var1, LocalDateTime var2);

    @Query(value="SELECT conversation_id, message_error, created_at, message_status FROM t_campaign_detail WHERE conversation_id IN (:conversationIds) AND message_status NOT IN ('read', 'delivered') ORDER BY conversation_id, created_at DESC LIMIT 1")
    public Flux<ErrorCampaignDetail> filterNumbersWithError(List<String> var1);

    @Query(value="UPDATE t_campaign_detail SET delivered = :delivered WHERE id = :id")
    public Mono<Integer> updateDeliveredById(@Param(value="id") Long var1, @Param(value="delivered") Boolean var2);

    @Query(value="UPDATE t_campaign_detail SET message_status = :message_status WHERE id = :id")
    public Mono<Integer> updateStatedCampaignById(@Param(value="id") Long var1, @Param(value="message_status") String var2);

    @Query(value="SELECT tc.id as campaign_id, tc.template_name , tc.category_name , tc.user_name , tc.created_at as campaign_created_at , tcd.conversation_id as phone_id , tcd.message_status as state_type, tcd.created_at as state_created_at\nfrom t_campaign tc, t_campaign_detail tcd\nwhere tc.id = tcd.campaign_id and tc.created_at BETWEEN :start AND :end ORDER BY tc.created_at  desc LIMIT :limit OFFSET :offset\n")
    public Flux<VwReportCampaignStated> findByCampaignCreatedAtBetween(@Param(value="start") LocalDateTime var1, @Param(value="end") LocalDateTime var2, @Param(value="limit") int var3, @Param(value="offset") int var4);

    @Query(value="SELECT COUNT(*) FROM t_campaign tc  WHERE tc.created_at  BETWEEN :start AND :end\n")
    public Mono<Long> countByCampaignCreatedAtBetween(@Param(value="start") LocalDateTime var1, @Param(value="end") LocalDateTime var2);

    @Query(value="select tc.id as campaign_id, tc.template_name , tc.category_name , tc.user_name , tc.created_at as campaign_created_at , tcd.conversation_id as phone_id , tcd.message_status as state_type, tcd.created_at as state_created_at from t_campaign tc, t_campaign_detail tcd where tc.id = tcd.campaign_id and tc.id = :id")
    public Flux<VwReportCampaignStated> exportReportStatedCsv(@Param(value="id") Long var1);
}

