/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.interceptors;

import com.whatsapp.campaign.config.ApiResponse;
import com.whatsapp.campaign.exceptions.CustomException;
import com.whatsapp.campaign.exceptions.TemplateNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={WebExchangeBindException.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleValidationExceptions(WebExchangeBindException ex) {
        HashMap errors = new HashMap();
        log.warn("Errores de validaci\u00f3n: {}", (Object)ex.getMessage());
        ex.getBindingResult().getAllErrors().forEach(error -> {
            String fieldName = ((FieldError)error).getField();
            String errorMessage = error.getDefaultMessage();
            errors.put(fieldName, errorMessage);
        });
        ApiResponse response = ApiResponse.error((int)HttpStatus.NOT_ACCEPTABLE.value(), errors);
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_ACCEPTABLE));
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleAccessDeniedException(AccessDeniedException ex) {
        log.warn("Acceso denegado: {}", (Object)ex.getMessage());
        ApiResponse response = ApiResponse.errorAuth((int)HttpStatus.FORBIDDEN.value(), (String)"No tienes permiso para realizar esta acci\u00f3n.");
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.FORBIDDEN));
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleAuthenticationException(AuthenticationException ex) {
        log.warn("Fallo de autenticaci\u00f3n: {}", (Object)ex.getMessage());
        ApiResponse response = ApiResponse.errorAuth((int)HttpStatus.UNAUTHORIZED.value(), (String)"Error de autenticaci\u00f3n.");
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.UNAUTHORIZED));
    }

    @ExceptionHandler(value={CustomException.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleCustomException(CustomException ex, ServerWebExchange exchange) {
        ApiResponse response = ApiResponse.errorMessage((int)ex.getHttpStatus().value(), (String)ex.getMessage());
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)ex.getHttpStatus()));
    }

    @ExceptionHandler(value={TemplateNotFoundException.class})
    public ResponseEntity<Map<String, String>> handleTemplateNotFoundException(TemplateNotFoundException ex) {
        HashMap<String, String> errorResponse = new HashMap<String, String>();
        errorResponse.put("message", ex.getMessage());
        return new ResponseEntity(errorResponse, (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={AsyncRequestTimeoutException.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleTimeout(ServerWebExchange exchange) {
        ApiResponse response = ApiResponse.error((int)HttpStatus.REQUEST_TIMEOUT.value(), (String)"La solicitud ha tardado demasiado tiempo en procesarse.");
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.REQUEST_TIMEOUT));
    }

    @ExceptionHandler(value={RuntimeException.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleRuntime(RuntimeException ex, ServerWebExchange exchange) {
        log.error("ERROR de ejecuci\u00f3n", (Throwable)ex);
        ApiResponse response = ApiResponse.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"Ha ocurrido un error inesperado.");
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR));
    }

    @ExceptionHandler(value={Exception.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleGeneral(Exception ex, ServerWebExchange exchange) {
        log.error("ERROR general", (Throwable)ex);
        ApiResponse response = ApiResponse.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"Error interno del servidor.");
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR));
    }
}

