/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.controller;

import com.whatsapp.campaign.data.tsa.RequestMessageModel;
import com.whatsapp.campaign.service.ThinkAgentService;
import com.whatsapp.campaign.service.WebhookService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"webhook"})
public class WebhookController {
    private static final Logger log = LoggerFactory.getLogger(WebhookController.class);
    private final Environment env;
    private final WebhookService webhookService;
    private final ThinkAgentService thinkAgentService;

    @GetMapping(value={""})
    public Mono<ResponseEntity<String>> verifyWebhook(@RequestParam(name="hub.verify_token", required=false) String verifyToken, @RequestParam(name="hub.challenge", required=false) String challenge) {
        log.info("Verificando webhook con token: {} y challenge: {}", (Object)verifyToken, (Object)challenge);
        String VERIFY_TOKEN = this.env.getProperty("whatsapp.verify.token");
        if (VERIFY_TOKEN.equals(verifyToken)) {
            return Mono.just((Object)new ResponseEntity((Object)challenge, (HttpStatusCode)HttpStatus.OK));
        }
        log.error("Error de verificaci\u00f3n: token no coincide");
        return Mono.just((Object)new ResponseEntity((Object)"Error de verificaci\u00f3n", (HttpStatusCode)HttpStatus.FORBIDDEN));
    }

    @PostMapping(value={""})
    public Mono<ResponseEntity<?>> handleWebhook(@RequestBody Object userResponse) {
        log.info("\ud83d\udce9 Webhook recibido: {}", userResponse);
        return this.webhookService.handleWebhook(userResponse);
    }

    @PostMapping(value={"/tsa/message"})
    public Mono<ResponseEntity<?>> handleTsaWebhook(@RequestBody RequestMessageModel userResponse) {
        log.info("Incomming TSA webhook: {}", (Object)userResponse);
        return this.thinkAgentService.sendMessageToWhatsappFromTSA(userResponse);
    }

    public Environment getEnv() {
        return this.env;
    }

    public WebhookService getWebhookService() {
        return this.webhookService;
    }

    public ThinkAgentService getThinkAgentService() {
        return this.thinkAgentService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebhookController)) {
            return false;
        }
        WebhookController other = (WebhookController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        WebhookService this$webhookService = this.getWebhookService();
        WebhookService other$webhookService = other.getWebhookService();
        if (this$webhookService == null ? other$webhookService != null : !this$webhookService.equals(other$webhookService)) {
            return false;
        }
        ThinkAgentService this$thinkAgentService = this.getThinkAgentService();
        ThinkAgentService other$thinkAgentService = other.getThinkAgentService();
        return !(this$thinkAgentService == null ? other$thinkAgentService != null : !this$thinkAgentService.equals(other$thinkAgentService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebhookController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        WebhookService $webhookService = this.getWebhookService();
        result = result * 59 + ($webhookService == null ? 43 : $webhookService.hashCode());
        ThinkAgentService $thinkAgentService = this.getThinkAgentService();
        result = result * 59 + ($thinkAgentService == null ? 43 : $thinkAgentService.hashCode());
        return result;
    }

    public String toString() {
        return "WebhookController(env=" + String.valueOf(this.getEnv()) + ", webhookService=" + String.valueOf(this.getWebhookService()) + ", thinkAgentService=" + String.valueOf(this.getThinkAgentService()) + ")";
    }

    public WebhookController(Environment env, WebhookService webhookService, ThinkAgentService thinkAgentService) {
        this.env = env;
        this.webhookService = webhookService;
        this.thinkAgentService = thinkAgentService;
    }
}

