/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.controller;

import com.whatsapp.campaign.data.PagedResponse;
import com.whatsapp.campaign.entity.Client;
import com.whatsapp.campaign.entity.VwReportHistoryMessage;
import com.whatsapp.campaign.service.HistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/history-conversation"})
public class HistoryController {
    private static final Logger log = LoggerFactory.getLogger(HistoryController.class);
    private final HistoryService historyService;

    @PostMapping(value={"/conversation"})
    public Mono<ResponseEntity<PagedResponse<Client>>> getHistoryConversations(ServerWebExchange exchange) {
        return exchange.getFormData().flatMap(formData -> {
            String filterParam = (String)formData.getFirst((Object)"filterValue");
            String pageParam = (String)formData.getFirst((Object)"page");
            String sizeParam = (String)formData.getFirst((Object)"size");
            String sortDirectionParam = (String)formData.getFirst((Object)"sortDirection");
            int page = pageParam != null ? Integer.parseInt(pageParam) : 0;
            int size = sizeParam != null ? Integer.parseInt(sizeParam) : 10;
            String sortDirection = sortDirectionParam != null ? sortDirectionParam : "desc";
            return this.historyService.getHistoryConversations(page, size, sortDirection, filterParam).map(pagedResponse -> new ResponseEntity(pagedResponse, (HttpStatusCode)HttpStatus.OK)).defaultIfEmpty((Object)new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT));
        });
    }

    @PostMapping(value={"/conversation-item"})
    public Mono<ResponseEntity<PagedResponse<VwReportHistoryMessage>>> getHistoryConversationItems(ServerWebExchange exchange) {
        return exchange.getFormData().flatMap(formData -> {
            String pageParam = (String)formData.getFirst((Object)"page");
            String sizeParam = (String)formData.getFirst((Object)"size");
            String sortDirectionParam = (String)formData.getFirst((Object)"sortDirection");
            String idPlatformParam = (String)formData.getFirst((Object)"idPlatform");
            int page = pageParam != null ? Integer.parseInt(pageParam) : 0;
            int size = sizeParam != null ? Integer.parseInt(sizeParam) : 10;
            String sortDirection = sortDirectionParam != null ? sortDirectionParam : "desc";
            String idPlatform = idPlatformParam != null ? idPlatformParam : "";
            return this.historyService.getCampaigReportHistoryMessage(page, size, sortDirection, idPlatform).map(pagedResponse -> new ResponseEntity(pagedResponse, (HttpStatusCode)HttpStatus.OK)).defaultIfEmpty((Object)new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT));
        });
    }

    public HistoryController(HistoryService historyService) {
        this.historyService = historyService;
    }
}

