/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.whatsapp.campaign.exceptions.CustomException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ApiResponse<T> {
    private int status;
    private String message;
    private Map<String, String> messages;
    private T data;

    public ApiResponse(int statusCode, String message, T data) {
        this.status = statusCode;
        this.message = message;
        this.data = data;
    }

    public ApiResponse(int statusCode, T data) {
        this.status = statusCode;
        this.data = data;
    }

    public ApiResponse(int statusCode, Map<String, String> messages) {
        this.status = statusCode;
        this.messages = messages;
    }

    public static <T> ApiResponse<T> okMessage(String message) {
        return new ApiResponse(200, message, null);
    }

    public static <T> ApiResponse<T> ok(T data) {
        return new ApiResponse(200, "Operaci\u00f3n exitosa", data);
    }

    public static <T> ApiResponse<T> ok(int status, T data) {
        return new ApiResponse(status, data);
    }

    public static <T> ApiResponse<T> error(int statusCode, Map<String, String> messages) {
        return new ApiResponse(statusCode, messages);
    }

    public static <T> ApiResponse<T> errorAuth(int statusCode, String message) {
        return new ApiResponse(statusCode, message, null);
    }

    public static <T> ApiResponse<T> error(int statusCode, String message) {
        HashMap<String, String> messages = new HashMap<String, String>();
        messages.put("error", message);
        return new ApiResponse(statusCode, messages);
    }

    public static <T> ApiResponse<T> errorMessage(int statusCode, String tittleMessage) {
        return new ApiResponse(statusCode, tittleMessage, null);
    }

    public static <T> ApiResponse<T> customException(HttpStatus httpStatus, String message) {
        throw new CustomException(message, httpStatus);
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getMessages() {
        return this.messages;
    }

    public T getData() {
        return (T)this.data;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMessages(Map<String, String> messages) {
        this.messages = messages;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiResponse)) {
            return false;
        }
        ApiResponse other = (ApiResponse)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Map this$messages = this.getMessages();
        Map other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Map $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ApiResponse(status=" + this.getStatus() + ", message=" + this.getMessage() + ", messages=" + String.valueOf(this.getMessages()) + ", data=" + String.valueOf(this.getData()) + ")";
    }

    public ApiResponse() {
    }

    public ApiResponse(int status, String message, Map<String, String> messages, T data) {
        this.status = status;
        this.message = message;
        this.messages = messages;
        this.data = data;
    }
}

