/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.client.whatsapp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.campaign.client.utils.WebClientUtils;
import com.whatsapp.campaign.client.whatsapp.models.FileMessageRequest;
import com.whatsapp.campaign.client.whatsapp.models.FileModelWhatsapp;
import com.whatsapp.campaign.client.whatsapp.models.TextMessageRequest;
import com.whatsapp.campaign.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.campaign.data.ConversationAnalyticsResponse;
import com.whatsapp.campaign.data.ConversationSummary;
import com.whatsapp.campaign.data.ConversationSummaryResponse;
import com.whatsapp.campaign.data.TemplateData;
import com.whatsapp.campaign.data.WhatsAppCampaignModel;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class ApiWhatsApp
implements ApiWhatsAppService {
    private static final Logger log = LoggerFactory.getLogger(ApiWhatsApp.class);
    private final WebClient webClient;
    private final Environment env;
    private final ObjectMapper objectMapper;

    public ApiWhatsApp(@Qualifier(value="whatsappWebClient") WebClient webClient, Environment env, ObjectMapper objectMapper) {
        this.webClient = webClient;
        this.env = env;
        this.objectMapper = objectMapper;
    }

    public Mono<TemplateData> getTemplates() {
        String WHATSAPP_API_TEMPLATE = this.env.getProperty("whatsapp.api.templates");
        String apiToken = this.env.getProperty("whatsapp.token");
        return WebClientUtils.handleWebClientResponse((WebClient.RequestHeadersSpec)this.webClient.get().uri(WHATSAPP_API_TEMPLATE, new Object[0]).header("Authorization", new String[]{"Bearer " + apiToken}), TemplateData.class, (String)"Get templates from whatsapp meta").flatMap(response -> Mono.just((Object)((TemplateData)response.getBody())));
    }

    public Mono<String> sendMessageTemplateToWhatsAppAPI(Object payload) {
        String apiToken = this.env.getProperty("whatsapp.token");
        log.info("apiToken: {}", (Object)apiToken);
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        log.info("WHATSAPP_API_URL: {}", (Object)WHATSAPP_API_URL);
        log.warn(payload.toString());
        return WebClientUtils.handleWebClientResponse((WebClient.RequestHeadersSpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(WHATSAPP_API_URL, new Object[0])).header("Authorization", new String[]{"Bearer " + apiToken})).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)payload)), String.class, (String)"Send message template to WhatsApp API").flatMap(response -> Mono.just((Object)((String)response.getBody())));
    }

    public Mono<ConversationSummaryResponse> getConversationSummary(Date fecha_inicio, Date fecha_fin) {
        double MARKETING_COST = 0.1542;
        double UTILITY_COST = 0.0235;
        double SERVICE_COST = 0.0881;
        return this.getConversationAnalytics(fecha_inicio, fecha_fin).map(response -> {
            Map<String, Integer> conversationCounts = response.getConversationAnalytics().getData().stream().flatMap(data -> data.getDataPoints().stream()).collect(Collectors.groupingBy(ConversationAnalyticsResponse.DataPoint::getConversationCategory, Collectors.summingInt(ConversationAnalyticsResponse.DataPoint::getConversation)));
            List summaries = conversationCounts.entrySet().stream().map(entry -> {
                String category = (String)entry.getKey();
                int totalConversations = (Integer)entry.getValue();
                double costPerConversation = 0.0;
                switch (category.toUpperCase()) {
                    case "MARKETING": {
                        costPerConversation = MARKETING_COST;
                        break;
                    }
                    case "UTILITY": {
                        costPerConversation = UTILITY_COST;
                        break;
                    }
                    case "SERVICE": {
                        costPerConversation = SERVICE_COST;
                    }
                }
                double totalCost = (double)totalConversations * costPerConversation;
                return new ConversationSummary(category, totalConversations, totalCost);
            }).collect(Collectors.toList());
            double totalCost = summaries.stream().mapToDouble(ConversationSummary::getTotalCost).sum();
            totalCost = BigDecimal.valueOf(totalCost).setScale(2, RoundingMode.HALF_UP).doubleValue();
            return new ConversationSummaryResponse(summaries, totalCost);
        });
    }

    public Mono<ConversationAnalyticsResponse> getConversationAnalytics(Date fecha_inicio, Date fecha_fin) {
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.business.url");
        String TOKEN = this.env.getProperty("whatsapp.token");
        long fecha_inicio_tsp = fecha_inicio.getTime() / 1000L;
        long fecha_fin_tsp = fecha_fin.getTime() / 1000L;
        return this.webClient.get().uri(WHATSAPP_API_URL + "/?fields=conversation_analytics.start(" + fecha_inicio_tsp + ").end(" + fecha_fin_tsp + ").granularity(DAILY).dimensions(CONVERSATION_CATEGORY).conversation_types(REGULAR)", new Object[0]).header("Authorization", new String[]{"Bearer " + TOKEN}).retrieve().bodyToMono(ConversationAnalyticsResponse.class).doOnError(e -> log.error("Error downloading file", e)).onErrorResume(e -> Mono.empty());
    }

    public Mono<String> sendMessageTemplate(WhatsAppCampaignModel request) {
        String apiToken = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        return WebClientUtils.handleWebClientResponse((WebClient.RequestHeadersSpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(WHATSAPP_API_URL, new Object[0])).header("Authorization", new String[]{"Bearer " + apiToken})).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)request)), String.class, (String)"Send message template to WhatsApp API").flatMap(response -> Mono.just((Object)((String)response.getBody())));
    }

    public Mono<FileModelWhatsapp> downloadMediaFile(String mediaId) {
        log.info("Downloading mediaFile from {}", (Object)mediaId);
        String apiToken = this.env.getProperty("whatsapp.token");
        String templateUrlMediaFile = this.env.getProperty("whatsapp.api.media");
        templateUrlMediaFile = templateUrlMediaFile.replace("{mediaId}", mediaId);
        return this.webClient.get().uri(templateUrlMediaFile, new Object[0]).header("Authorization", new String[]{"Bearer " + apiToken}).retrieve().bodyToMono(FileModelWhatsapp.class).doOnError(e -> log.error("Error downloading file", e)).onErrorResume(e -> Mono.empty());
    }

    public Mono<ResponseEntity<String>> sendTextMessage(TextMessageRequest req) {
        log.info("Sending text message to {}", (Object)req.getPhoneNumber());
        String TOKEN = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(TOKEN);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("messaging_product", "whatsapp");
        body.put("to", req.getPhoneNumber());
        body.put("type", "text");
        body.put("text", Collections.singletonMap("body", req.getMessage()));
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(WHATSAPP_API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(body).retrieve().toEntity(String.class).doOnSuccess(response -> {
            if (response.getStatusCode() == HttpStatus.OK) {
                log.info("Text message sent successfully!");
            } else {
                log.error("Failed to send text message: " + (String)response.getBody());
            }
        }).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)this.getMessageMetaId((String)response.getBody()))));
    }

    public Mono<ResponseEntity<String>> sendImageMessage(FileMessageRequest req) {
        log.info("Sending image {}", (Object)req);
        String TOKEN = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(TOKEN);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("messaging_product", "whatsapp");
        body.put("to", req.getPhoneNumber());
        body.put("type", "image");
        HashMap<String, String> image = new HashMap<String, String>();
        image.put("link", req.getFileUrl());
        if (req.getCaption() != null && !req.getCaption().isEmpty()) {
            image.put("caption", req.getCaption());
        }
        body.put("image", image);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(WHATSAPP_API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(body).retrieve().toEntity(String.class).doOnSuccess(response -> log.info("Image message sent successfully!")).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)this.getMessageMetaId((String)response.getBody())))).doOnError(error -> log.error("Error sending image message: ", error));
    }

    public Mono<ResponseEntity<String>> sendDocumentMessage(FileMessageRequest req) {
        log.info("Sending image {}", (Object)req);
        String TOKEN = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(TOKEN);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("messaging_product", "whatsapp");
        body.put("to", req.getPhoneNumber());
        body.put("type", "document");
        HashMap<String, String> file = new HashMap<String, String>();
        file.put("link", req.getFileUrl());
        if (req.getCaption() != null && !req.getCaption().isEmpty()) {
            file.put("caption", req.getCaption());
        }
        body.put("document", file);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(WHATSAPP_API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(body).retrieve().toEntity(String.class).doOnSuccess(response -> log.info("Image message sent successfully!")).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)this.getMessageMetaId((String)response.getBody())))).doOnError(error -> log.error("Error sending video message: ", error));
    }

    public Mono<ResponseEntity<String>> sendVideoMessage(FileMessageRequest req) {
        log.info("Sending image {}", (Object)req);
        String TOKEN = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(TOKEN);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("messaging_product", "whatsapp");
        body.put("to", req.getPhoneNumber());
        body.put("type", "video");
        HashMap<String, String> video = new HashMap<String, String>();
        video.put("link", req.getFileUrl());
        if (req.getCaption() != null && !req.getCaption().isEmpty()) {
            video.put("caption", req.getCaption());
        }
        body.put("video", video);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(WHATSAPP_API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(body).retrieve().toEntity(String.class).doOnSuccess(response -> log.info("Image message sent successfully!")).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)this.getMessageMetaId((String)response.getBody())))).doOnError(error -> log.error("Error sending video message: ", error));
    }

    public Mono<ResponseEntity<String>> sendAudioMessage(FileMessageRequest req) {
        log.info("Sending audio {}", (Object)req);
        String TOKEN = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(TOKEN);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("messaging_product", "whatsapp");
        body.put("to", req.getPhoneNumber());
        body.put("type", "audio");
        HashMap<String, String> file = new HashMap<String, String>();
        file.put("link", req.getFileUrl());
        body.put("audio", file);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(WHATSAPP_API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(body).retrieve().toEntity(String.class).doOnSuccess(response -> log.info("Audio message sent successfully!")).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)this.getMessageMetaId((String)response.getBody())))).doOnError(error -> log.error("Error sending audio message: ", error));
    }

    private String getMessageMetaId(String jsonString) {
        try {
            JsonNode rootNode = this.objectMapper.readTree(jsonString);
            JsonNode messagesNode = rootNode.path("messages");
            if (messagesNode.isArray() && messagesNode.size() > 0) {
                String messageId = messagesNode.get(0).path("id").asText();
                System.out.println("ID del mensaje: " + messageId);
                return messageId;
            }
            System.out.println("No se encontr\u00f3 el ID del mensaje.");
            return UUID.randomUUID().toString();
        }
        catch (Exception e) {
            return UUID.randomUUID().toString();
        }
    }
}

