/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.cache;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

@Service
public class RelationCampaignStated {
    private static final Logger log = LoggerFactory.getLogger(RelationCampaignStated.class);
    private static final String REDIS_HASH_KEY = "relation-campaign-stated";
    private final ReactiveRedisTemplate<String, String> redisTemplate;

    public RelationCampaignStated(ReactiveRedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public Mono<Boolean> setData(String wamid, String id_campaign) {
        return this.redisTemplate.opsForHash().put((Object)REDIS_HASH_KEY, (Object)wamid, (Object)id_campaign).timeout(Duration.ofSeconds(5L)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(200L))).onErrorResume(e -> {
            log.error("Fallo al guardar el id en Redis para wamid {}: {}", new Object[]{wamid, e.getMessage(), e});
            return Mono.just((Object)false);
        });
    }

    public Mono<String> getData(String wamid) {
        return this.redisTemplate.opsForHash().get((Object)REDIS_HASH_KEY, (Object)wamid).timeout(Duration.ofSeconds(5L)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(200L))).map(Object::toString).onErrorResume(e -> {
            log.error("Fallo al obtener el id de Redis para wamid {}: {}", new Object[]{wamid, e.getMessage(), e});
            return Mono.empty();
        });
    }

    public Mono<Boolean> exists(String wamid) {
        return this.redisTemplate.opsForHash().hasKey((Object)REDIS_HASH_KEY, (Object)wamid).timeout(Duration.ofSeconds(5L)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(200L))).onErrorResume(e -> {
            log.error("Fallo al verificar la existencia del wamid {} en Redis: {}", new Object[]{wamid, e.getMessage(), e});
            return Mono.just((Object)false);
        });
    }

    public Flux<Map.Entry<String, String>> getDataBatch(List<String> wamids) {
        return Flux.fromIterable(wamids).flatMap(id -> this.redisTemplate.opsForHash().get((Object)REDIS_HASH_KEY, id).timeout(Duration.ofSeconds(5L)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(200L))).map(value -> Map.entry(id, value.toString()))).onErrorResume(e -> {
            log.error("Fallo al obtener el batch de wamid en Redis: {}", (Object)e.getMessage(), e);
            return Flux.empty();
        });
    }

    public Mono<Long> delete(String wamid) {
        return this.redisTemplate.opsForHash().remove((Object)REDIS_HASH_KEY, new Object[]{wamid});
    }

    public Mono<Long> deleteByValue(String id_campaign) {
        return this.redisTemplate.opsForHash().entries((Object)REDIS_HASH_KEY).filter(entry -> id_campaign.equals(entry.getValue().toString())).map(entry -> entry.getKey()).next().flatMap(field -> this.redisTemplate.opsForHash().remove((Object)REDIS_HASH_KEY, new Object[]{field}));
    }
}

