/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.cache;

import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

@Service
public class PhoneBuisnesIdCacheService {
    private static final Logger log = LoggerFactory.getLogger(PhoneBuisnesIdCacheService.class);
    private final ReactiveRedisTemplate<String, String> redisTemplate;

    public Mono<Boolean> setPhoneId(String phoneMetaIdentifier, Long phoneId) {
        return this.redisTemplate.opsForValue().set((Object)phoneMetaIdentifier, (Object)String.valueOf(phoneId), Duration.ofHours(24L)).flatMap(success -> {
            if (success.booleanValue()) {
                log.info("Phone ID set in Redis: {} -> {}", (Object)phoneMetaIdentifier, (Object)phoneId);
                return Mono.just((Object)true);
            }
            log.error("Failed to set phone ID in Redis: {} -> {}", (Object)phoneMetaIdentifier, (Object)phoneId);
            return Mono.error((Throwable)new RuntimeException("Failed to set phone ID in Redis"));
        });
    }

    public Mono<Long> getPhoneIdByPhoneIdentifier(String phoneMetaIdentifier) {
        return this.redisTemplate.opsForValue().get((Object)phoneMetaIdentifier).timeout(Duration.ofSeconds(5L)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(200L))).flatMap(value -> {
            try {
                return Mono.just((Object)Long.parseLong(value.toString()));
            }
            catch (NumberFormatException e) {
                return Mono.empty();
            }
            catch (Exception e) {
                log.error("Error retrieving phone ID from Redis: {}", (Object)e.getMessage(), (Object)e);
                return Mono.empty();
            }
        }).switchIfEmpty(Mono.empty());
    }

    public PhoneBuisnesIdCacheService(ReactiveRedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

