/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.cache;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

@Service
public class ClientCacheService {
    private static final Logger log = LoggerFactory.getLogger(ClientCacheService.class);
    private static final String REDIS_HASH_KEY = "client-phone";
    private final ReactiveRedisTemplate<String, String> redisTemplate;

    public ClientCacheService(ReactiveRedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public Mono<Boolean> setData(String phone, String id_campaign) {
        return this.redisTemplate.opsForHash().put((Object)REDIS_HASH_KEY, (Object)this.normalizePhone(phone), (Object)id_campaign).timeout(Duration.ofSeconds(5L)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(200L))).onErrorResume(e -> {
            log.error("Fallo al guardar el phone en Redis para client {}: {}", new Object[]{phone, e.getMessage(), e});
            return Mono.just((Object)false);
        });
    }

    public Mono<String> getData(String phone) {
        return this.redisTemplate.opsForHash().get((Object)REDIS_HASH_KEY, (Object)this.normalizePhone(phone)).timeout(Duration.ofSeconds(5L)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(200L))).map(Object::toString).onErrorResume(e -> {
            log.error("Fallo al obtener el phone de Redis para client {}: {}", new Object[]{phone, e.getMessage(), e});
            return Mono.empty();
        });
    }

    public Mono<Boolean> exists(String phone) {
        return this.redisTemplate.opsForHash().hasKey((Object)REDIS_HASH_KEY, (Object)this.normalizePhone(phone)).timeout(Duration.ofSeconds(5L)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(200L))).onErrorResume(e -> {
            log.error("Fallo al verificar la existencia del client {} en Redis: {}", new Object[]{phone, e.getMessage(), e});
            return Mono.just((Object)false);
        });
    }

    public Flux<Map.Entry<String, String>> getDataBatch(List<String> phones) {
        return Flux.fromIterable(phones).flatMap(id -> {
            String phone = this.normalizePhone(id);
            return this.redisTemplate.opsForHash().get((Object)REDIS_HASH_KEY, (Object)phone).timeout(Duration.ofSeconds(5L)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(200L))).map(value -> Map.entry(phone, value.toString()));
        }).onErrorResume(e -> {
            log.error("Fallo al obtener el batch de wamid en Redis: {}", (Object)e.getMessage(), e);
            return Flux.empty();
        });
    }

    public Mono<Long> delete(String phone) {
        String normalizedPhone = this.normalizePhone(phone);
        return this.redisTemplate.opsForHash().remove((Object)REDIS_HASH_KEY, new Object[]{normalizedPhone}).doOnSuccess(count -> log.info("Eliminado {} de Redis ({} registros afectados)", (Object)normalizedPhone, count)).doOnError(e -> log.error("Error al eliminar {} de Redis: {}", (Object)normalizedPhone, (Object)e.getMessage()));
    }

    public String normalizePhone(String input) {
        if (input == null || input.isBlank()) {
            return null;
        }
        String phone = input.replaceAll("[^\\d]", "");
        if (phone.length() == 10 && phone.startsWith("0")) {
            return "593" + phone.substring(1);
        }
        if (phone.startsWith("593") && phone.length() == 12) {
            return phone;
        }
        return null;
    }
}

