/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.client.external.service.SendMessagesToApiService;
import com.agent.client.tsa.message.service.TsaMessageService;
import com.agent.exceptions.CustomException;
import com.agent.tsa.data.RequestMessageModel;
import com.agent.tsa.entity.TConversation;
import com.agent.tsa.events.MessageEvent;
import com.agent.tsa.models.conversation.CreateConversationModel;
import com.agent.tsa.models.conversation.TextMessage;
import com.agent.tsa.service.ContactService;
import com.agent.tsa.service.ConversationService;
import com.agent.tsa.service.FileService;
import com.agent.tsa.service.MessageService;
import com.agent.tsa.service.TeamService;
import com.agent.tsa.utils.StatusUtil;
import com.agent.tsa.utils.TemplateMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class MessageServiceImpl
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    private final TeamService teamService;
    private final ConversationService conversationService;
    private final SendMessagesToApiService sendMessagesToApiService;
    private final TsaMessageService tsaMessageService;
    private final ContactService contactService;
    private final FileService fileService;
    private final Environment env;

    public Mono<Void> processRequestToSendMessage(RequestMessageModel request, String callback) {
        return this.conversationService.findConversationByIdentifier(request.getId()).defaultIfEmpty((Object)new TConversation()).flatMap(conv -> {
            if (conv.getId() == null) {
                return this.generateNewConversationAndSendMessage(request, callback);
            }
            System.out.println("VALUE ENCONTROA " + String.valueOf(conv));
            return this.switchMessage(request, conv);
        });
    }

    private Mono<Void> switchMessage(RequestMessageModel request, TConversation conversation) {
        if (request.getPayload() == null) {
            return Mono.error((Throwable)new CustomException("La estructura de la solicitud no es correcta.", HttpStatus.BAD_REQUEST));
        }
        String messageType = request.getPayload().getType();
        boolean hasRepliedMessage = request.getPayload().getRepliedMessage() != null;
        String newMessage = hasRepliedMessage ? TemplateMessage.messageBuilded((String)request.getPayload().getRepliedMessage(), (String)request.getPayload().getContent()) : request.getPayload().getContent();
        switch (messageType) {
            case "text": {
                TextMessage textMessage = new TextMessage();
                textMessage.setMessageType("incoming");
                textMessage.setContent(newMessage);
                textMessage.setPrivate(false);
                textMessage.setContentType(messageType);
                return this.sendMessage(textMessage, conversation.getConversationId());
            }
            case "file": {
                String caption = hasRepliedMessage ? TemplateMessage.messageBuilded((String)request.getPayload().getRepliedMessage(), (String)"") : null;
                log.info("Caption file {}", (Object)caption);
                return this.fileService.downloadFilesFromMeta(request.getPayload().getContent(), "").flatMap(fileDownloadMeta -> this.tsaMessageService.sendMultipartMessageToTSA(fileDownloadMeta, String.valueOf(conversation.getConversationId()), caption).then());
            }
        }
        return Mono.error((Throwable)new CustomException("El tipo de mensaje no es correcto.", HttpStatus.BAD_REQUEST));
    }

    private Mono<Void> generateNewConversationAndSendMessage(RequestMessageModel request, String callbackId) {
        String inboxId = this.env.getProperty("tsa.inbox.default");
        log.info("NEW CONVERSATION");
        return this.contactService.findIdTsaByIdentifier(request.getNick(), request.getId(), request.getChannel()).flatMap(contactId -> this.teamService.findTeamIdByCallback(callbackId).flatMap(teamId -> {
            CreateConversationModel convMessageModel = new CreateConversationModel(inboxId, contactId, StatusUtil.ST_CONVERSATION_OPEN, teamId, request.getPayload().getContent());
            if (request.getPayload().getRepliedMessage() != null) {
                String newMessage = TemplateMessage.messageBuilded((String)request.getPayload().getRepliedMessage(), (String)request.getPayload().getContent());
                convMessageModel.getMessage().setContent(newMessage);
            }
            return this.conversationService.openNewConversation(convMessageModel);
        }));
    }

    private Mono<Void> sendMessage(TextMessage textMessage, Long conversationId) {
        return this.tsaMessageService.sendMesssageToTSA(textMessage, String.valueOf(conversationId)).then(Mono.empty());
    }

    public Mono<ResponseEntity<String>> sendMessagesToAPI(MessageEvent callback) {
        MessageEvent.Conversation conversation = callback.getConversation();
        if (conversation != null) {
            String messageType = callback.getMessageType();
            String eventMessage = callback.getEvent();
            if (messageType.equalsIgnoreCase("incoming") || messageType.equals("template") && eventMessage.equals("message_updated")) {
                return Mono.just((Object)ResponseEntity.ok((Object)"OK"));
            }
            if (eventMessage.equals("message_updated") && callback.getContent() != null && callback.getContent().toUpperCase().contains("ESTE MENSAJE SE HA ELIMINADO")) {
                log.info("MENSAJE ELIMINADO IGNORADO {}", (Object)callback.getContent());
                return Mono.just((Object)ResponseEntity.badRequest().body((Object)"MENSAJE NO ELIMINADO EN EL CLIENTE"));
            }
            if (messageType.equals("template")) {
                String templateContentType = callback.getContentType();
                String content = callback.getContent();
                if (templateContentType.equalsIgnoreCase("text")) {
                    MessageEvent.Sender sender = conversation.getMeta().getSender();
                    if (sender.getIdentifier() == null) {
                        log.error("Identifier is null");
                        return Mono.just((Object)ResponseEntity.badRequest().body((Object)"EL NUMERO DE TELEFONO NO EXISTE"));
                    }
                    String identifierClient = sender.getIdentifier();
                    RequestMessageModel messageModel = new RequestMessageModel(identifierClient, "message", "text", content);
                    return this.sendMessagesToApiService.sendMessageToWebhook(messageModel).flatMap(ignore -> Mono.just((Object)ResponseEntity.ok((Object)"TEMPLATE MESSAGE SENT")));
                }
            }
            List messages = conversation.getMessages();
            MessageEvent.Conversation.Meta meta = conversation.getMeta();
            if (messages != null && !messages.isEmpty()) {
                for (MessageEvent.Conversation.MessageDetails msg : messages) {
                    MessageEvent.Sender sender = meta.getSender();
                    String userIdentifier = sender.getIdentifier();
                    if (userIdentifier == null) {
                        log.error("Identifier is null");
                        return Mono.just((Object)ResponseEntity.badRequest().body((Object)"EL IDENTIFIADOR DEL USUARIO NO EXISTE"));
                    }
                    String contentType = msg.getContentType();
                    String content = msg.getContent();
                    List attachments = msg.getAttachments();
                    if (!contentType.equalsIgnoreCase("text") && !contentType.equalsIgnoreCase("input_csat")) continue;
                    if (content != null) {
                        RequestMessageModel messageModel = new RequestMessageModel(userIdentifier, "message", "text", content);
                        return this.sendMessagesToApiService.sendMessageToWebhook(messageModel).flatMap(ignore -> this.sendAttachments(userIdentifier, attachments).then(Mono.just((Object)ResponseEntity.ok().build())));
                    }
                    return this.sendAttachments(userIdentifier, attachments).then(Mono.just((Object)ResponseEntity.ok().build()));
                }
            }
        }
        return null;
    }

    public Mono<String> sendAttachments(String userIdentifier, List<MessageEvent.Attachment> attachments) {
        if (attachments != null && !attachments.isEmpty()) {
            return Flux.fromIterable(attachments).flatMap(att -> {
                if (att.getFileType().equals("file")) {
                    att.setFileType("document");
                } else {
                    att.setFileType(att.getFileType());
                }
                if (att.getFileType().equals("audio")) {
                    return this.fileService.convertAudioFromUrl(att.getDataUrl()).flatMap(audioUrl -> {
                        String templateUrl = this.env.getProperty("client.download.files").replace("{file_id}", (CharSequence)audioUrl);
                        RequestMessageModel messageModel = new RequestMessageModel(userIdentifier, "message", "audio", templateUrl);
                        log.info("AUDIO URL {}", (Object)templateUrl);
                        return this.sendMessagesToApiService.sendMessageToWebhook(messageModel).doOnSuccess(ignore -> log.info("Attachment sent")).doOnError(error -> log.error("Failed to send attachment for URL: {}. Error: {}", (Object)att.getDataUrl(), (Object)error.getMessage()));
                    });
                }
                RequestMessageModel messageModel = new RequestMessageModel(userIdentifier, "message", att.getFileType(), att.getDataUrl());
                return this.sendMessagesToApiService.sendMessageToWebhook(messageModel).doOnSuccess(ignore -> log.info("Attachment sent")).doOnError(error -> log.error("Failed to send attachment for URL: {}. Error: {}", (Object)att.getDataUrl(), (Object)error.getMessage()));
            }).then(Mono.just((Object)"TODOS LOS ARCHIVOS PROCESADOS"));
        }
        return Mono.just((Object)"NO EXISTEN DOCUMENTOS PARA ENVIAR");
    }

    public MessageServiceImpl(TeamService teamService, ConversationService conversationService, SendMessagesToApiService sendMessagesToApiService, TsaMessageService tsaMessageService, ContactService contactService, FileService fileService, Environment env) {
        this.teamService = teamService;
        this.conversationService = conversationService;
        this.sendMessagesToApiService = sendMessagesToApiService;
        this.tsaMessageService = tsaMessageService;
        this.contactService = contactService;
        this.fileService = fileService;
        this.env = env;
    }
}

