/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.client.tsa.files.TsaFileServer;
import com.agent.tsa.service.FileDownloadService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class FileDownloadServiceImpl
implements FileDownloadService {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadServiceImpl.class);
    private final TsaFileServer tsaApiService;

    public Mono<String> downloadFile(String fileUrl, String fileId, String rutaTemporal) {
        return Mono.fromCallable(() -> {
            File tempDir = new File(rutaTemporal);
            if (!tempDir.exists() && !tempDir.mkdirs()) {
                throw new IOException("No se pudo crear el directorio temporal: " + rutaTemporal);
            }
            File tempFile = new File(tempDir, fileId.concat(".oga"));
            System.out.println("Guardando archivo temporal en: " + tempFile.getAbsolutePath());
            return tempFile;
        }).flatMap(tempFile -> this.tsaApiService.getFileBytesWithRedirectHandling(fileUrl).doOnSuccess(fileBytes -> {
            try (FileOutputStream outputStream = new FileOutputStream((File)tempFile);){
                outputStream.write((byte[])fileBytes);
                outputStream.flush();
            }
            catch (Exception e) {
                throw new RuntimeException("Error al guardar el archivo: " + e.getMessage(), e);
            }
        }).map(fileBytes -> {
            if (tempFile.length() == 0L) {
                throw new RuntimeException("El archivo descargado est\u00e1 vac\u00edo: " + tempFile.getAbsolutePath());
            }
            System.out.println("Archivo descargado exitosamente: " + tempFile.getAbsolutePath() + " (Tama\u00f1o: " + tempFile.length() + " bytes)");
            return tempFile.getAbsolutePath();
        }));
    }

    public FileDownloadServiceImpl(TsaFileServer tsaApiService) {
        this.tsaApiService = tsaApiService;
    }
}

