/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.client.tsa.contact.service.TsaContactApiService;
import com.agent.client.tsa.conversation.service.TsaConversationApiService.TsaConversationApiService;
import com.agent.tsa.entity.TContact;
import com.agent.tsa.entity.TConversation;
import com.agent.tsa.events.ConversationEvent;
import com.agent.tsa.models.conversation.CreateConversationModel;
import com.agent.tsa.repository.ConversationDAO;
import com.agent.tsa.service.ContactService;
import com.agent.tsa.service.ConversationService;
import com.agent.tsa.utils.StatusUtil;
import java.time.LocalDateTime;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ConversationServiceImpl
implements ConversationService {
    private static final Logger log = LoggerFactory.getLogger(ConversationServiceImpl.class);
    private final ConversationDAO conversationDAO;
    private final TsaContactApiService tsaContactApiService;
    private final TsaConversationApiService tsaConversationApiService;
    private final ContactService contactService;

    public Mono<TConversation> saveOrUpdateConversation(ConversationEvent convEvent, String event) {
        log.info("CONVERSATION EVENT: {}", (Object)event);
        Long contactId = convEvent.getContactInbox().getContactId();
        log.warn("contact id: {}", (Object)contactId);
        String code = UUID.randomUUID().toString();
        return this.validateIfContactExists(contactId).flatMap(contactIdSaved -> this.conversationDAO.findByConversationId(convEvent.getId()).flatMap(existingConv -> {
            System.out.println("null value pass " + code + " event" + event);
            return this.conversationDAO.save((Object)this.createConversationFromEvent(convEvent, existingConv, contactIdSaved));
        }).switchIfEmpty(Mono.defer(() -> {
            System.out.println("ejecutando segnda funcion " + code + " event" + event);
            return this.conversationDAO.save((Object)this.createConversationFromEvent(convEvent, null, contactIdSaved));
        })));
    }

    public Mono<Void> openNewConversation(CreateConversationModel conversationModel) {
        log.info("IS OPENING A NEW CONVERSATION");
        return this.tsaConversationApiService.createNewConversationTSA(conversationModel).then();
    }

    public Mono<TConversation> findConversationByIdentifier(String identifier) {
        return this.conversationDAO.findConversationByIdentifierAndStatus(identifier, StatusUtil.ST_CONVERSATION_OPEN);
    }

    private Mono<Long> validateIfContactExists(Long idTsa) {
        return this.contactService.findIdContactByIdTsa(idTsa).defaultIfEmpty((Object)0L).flatMap(contactId -> {
            log.info("contact allowed {}, find {}", contactId, (Object)idTsa);
            if (contactId != 0L) {
                return Mono.just((Object)contactId);
            }
            return this.tsaContactApiService.getContactById(idTsa).flatMap(payload -> {
                log.info("RESPONSE {}", payload);
                return this.contactService.saveOrUpdateContactFromApiConversation(payload).map(TContact::getId);
            });
        });
    }

    private TConversation createConversationFromEvent(ConversationEvent evt, TConversation conv, Long contactId) {
        ConversationEvent.Team team;
        log.info("CONVERSATION MODEL {}", (Object)conv);
        TConversation conversation = conv != null ? conv : new TConversation();
        conversation.setContactId(contactId);
        conversation.setConversationId(evt.getId());
        if (conv == null) {
            conversation.setCreatedAt(LocalDateTime.now());
        }
        conversation.setUpdatedAt(LocalDateTime.now());
        conversation.setStatus(evt.getStatus());
        conversation.setInboxId(evt.getInboxId());
        if (evt.getMeta() != null && (team = evt.getMeta().getTeam()) != null) {
            conversation.setTeamId(team.getId());
        }
        log.warn("CONVERSATION {}", (Object)conversation);
        return conversation;
    }

    public ConversationServiceImpl(ConversationDAO conversationDAO, TsaContactApiService tsaContactApiService, TsaConversationApiService tsaConversationApiService, ContactService contactService) {
        this.conversationDAO = conversationDAO;
        this.tsaContactApiService = tsaContactApiService;
        this.tsaConversationApiService = tsaConversationApiService;
        this.contactService = contactService;
    }
}

