/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.client.tsa.contact.models.CreateContactModel;
import com.agent.client.tsa.contact.models.CreateContactResponse;
import com.agent.client.tsa.contact.models.PayloadFindContactById;
import com.agent.client.tsa.contact.service.TsaContactApiService;
import com.agent.tsa.entity.TContact;
import com.agent.tsa.events.ContactEvent;
import com.agent.tsa.repository.ContactDAO;
import com.agent.tsa.service.ContactService;
import java.time.Duration;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ContactServiceImpl
implements ContactService {
    private static final Logger log = LoggerFactory.getLogger(ContactServiceImpl.class);
    private final ContactDAO contactDAO;
    private final TsaContactApiService tsaContactApiService;

    public Mono<TContact> saveOrUpdateContact(ContactEvent contactEvent, String event) {
        log.info("CONTACT EVENT: {}", (Object)event);
        String identifier = contactEvent.getIdentifier();
        String integration = contactEvent.getCustomAttributes() != null && contactEvent.getCustomAttributes().getIntegration() != null ? contactEvent.getCustomAttributes().getIntegration() : "INTEGRATION_NOT_ALLOWED";
        return Mono.delay((Duration)Duration.ofSeconds(3L)).then(this.saveContact(contactEvent.getId(), contactEvent.getName(), contactEvent.getPhoneNumber(), identifier, integration));
    }

    public Mono<TContact> saveOrUpdateContactFromApiConversation(PayloadFindContactById response) {
        log.info("CONTACT EVENT: API CONVERSATION");
        String identifier = response.getPayload().getIdentifier();
        String integration = response.getPayload().getCustomAttributes() != null && response.getPayload().getCustomAttributes().getIntegration() != null ? response.getPayload().getCustomAttributes().getIntegration() : "INTEGRATION_NOT_ALLOWED";
        return this.saveContact(response.getPayload().getId(), response.getPayload().getName(), response.getPayload().getPhoneNumber(), identifier, integration);
    }

    private Mono<TContact> saveContact(Long idTsa, String name, String phoneNumber, String identifier, String integration) {
        String phoneNumberMod = phoneNumber == null ? null : phoneNumber.replace("+", "");
        return this.contactDAO.findByIdTsa(idTsa).flatMap(existingContact -> {
            existingContact.setName(name);
            if (phoneNumberMod != null) {
                existingContact.setPhoneNumber(phoneNumberMod);
            }
            existingContact.setIntegration(integration);
            existingContact.setIdentifier(identifier);
            existingContact.setUpdatedAt(LocalDateTime.now());
            return this.contactDAO.save(existingContact);
        }).switchIfEmpty(Mono.defer(() -> {
            TContact contact = new TContact();
            contact.setIdTsa(idTsa);
            contact.setName(name);
            if (phoneNumberMod != null) {
                contact.setPhoneNumber(phoneNumberMod);
            }
            contact.setIdentifier(identifier);
            contact.setCreatedAt(LocalDateTime.now());
            contact.setUpdatedAt(LocalDateTime.now());
            return this.contactDAO.save((Object)contact);
        })).onErrorResume(ex -> {
            log.error("Error al actualizar el contacto: {}", (Object)ex.getMessage());
            return Mono.empty();
        });
    }

    public Mono<Boolean> existsByIdTsa(Long idTsa) {
        return this.contactDAO.existsByIdTsa(idTsa);
    }

    public Mono<Long> findIdContactByIdTsa(Long idTsa) {
        return this.contactDAO.findIdContactByIdTsa(idTsa);
    }

    public Mono<Long> validateIfContactExistByIdentifierOrRegister(String identifier, String nick) {
        return this.contactDAO.findIdContactByIdentifier(identifier).switchIfEmpty(null);
    }

    public Mono<Long> findIdTsaByIdentifier(String name, String identifier, String integration) {
        return this.contactDAO.findIdTsaByIdentifier(identifier).switchIfEmpty(this.getContactTsaIdFromApi(name, identifier, integration));
    }

    public Mono<CreateContactResponse> createNewContactOnTSA(String name, String identifier, String integration) {
        String phoneNumber;
        integration = integration == null ? "whatsapp" : integration;
        String string = phoneNumber = integration.equalsIgnoreCase("whatsapp") ? "+" + identifier : null;
        String phone = phoneNumber != null ? (!phoneNumber.startsWith("+") ? "+" + phoneNumber : phoneNumber) : null;
        CreateContactModel contactModel = CreateContactModel.builder().name(name).phone_number(phone).identifier(identifier).customAttributes(new CreateContactModel.CustomAttributes(integration)).build();
        return this.tsaContactApiService.createNewContact(contactModel);
    }

    public Mono<Long> getContactTsaIdFromApi(String name, String identifier, String integration) {
        return this.tsaContactApiService.getContactByParam(identifier).flatMap(contactFromApi -> Mono.just((Object)contactFromApi.getId())).switchIfEmpty(this.createNewContactOnTSA(name, identifier, integration).flatMap(createdContact -> Mono.just((Object)createdContact.getPayload().getContact().getId())));
    }

    public ContactServiceImpl(ContactDAO contactDAO, TsaContactApiService tsaContactApiService) {
        this.contactDAO = contactDAO;
        this.tsaContactApiService = tsaContactApiService;
    }
}

