/*
 * Decompiled with CFR 0.152.
 */
package com.agent.controller;

import com.agent.tsa.data.RequestMessageModel;
import com.agent.tsa.service.MessageService;
import com.agent.tsa.service.ThinkAgentService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/webhook/tsa"})
public class WebhookController {
    private static final Logger log = LoggerFactory.getLogger(WebhookController.class);
    private final ThinkAgentService thinkAgentService;
    private final MessageService messageService;

    @PostMapping
    public Mono<ResponseEntity<String>> callbackTSA(@RequestBody Map<String, Object> body) {
        log.info("tsa webhook {}", body);
        try {
            return this.thinkAgentService.processWebhookFromTAS(body);
        }
        catch (Exception e) {
            log.error("EL BODY NO CORRESPONDE AL FORMATO CORRECTO ");
            return Mono.just((Object)ResponseEntity.ok().build());
        }
    }

    @PostMapping(value={"/sendMessage/{callbackid}"})
    public Mono<ResponseEntity<String>> callbackSendMessageTSA(@PathVariable String callbackid, @RequestBody RequestMessageModel request) {
        log.info("WEBHOOK MESSAGES {} {}", (Object)callbackid, (Object)request);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "ok");
        return this.messageService.processRequestToSendMessage(request, callbackid).then(Mono.just((Object)ResponseEntity.ok((Object)((Object)response).toString())));
    }

    @PostMapping(value={"/conversationStatusChanged"})
    public Mono<Void> conversationStatusChangred(@RequestBody Object body) {
        log.info("Conversation status webhook {}", body);
        return Mono.empty();
    }

    @PostMapping(value={"/test"})
    public Mono<Void> callbackSendMessageTSATEST(@RequestBody Object body) {
        log.info("simulation of client recipt {} {}", body);
        return Mono.empty();
    }

    public WebhookController(ThinkAgentService thinkAgentService, MessageService messageService) {
        this.thinkAgentService = thinkAgentService;
        this.messageService = messageService;
    }
}

