/*
 * Decompiled with CFR 0.152.
 */
package com.agent.controller;

import com.agent.tsa.service.FileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/file"})
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    private final FileService fileService;

    @GetMapping(value={"/download/{id}"})
    public Mono<ResponseEntity<byte[]>> getImage(@PathVariable String id) {
        return this.fileService.getImage(id).map(image -> {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.valueOf((String)image.getContentType()));
            headers.setContentLength((long)image.getData().length);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)image.getData());
        }).defaultIfEmpty((Object)ResponseEntity.notFound().build());
    }

    public FileController(FileService fileService) {
        this.fileService = fileService;
    }
}

