/*
 * Decompiled with CFR 0.152.
 */
package com.agent.auth;

import com.agent.auth.JwtAuthConverter;
import com.agent.interceptors.CustomAccessDeniedHandler;
import com.agent.interceptors.CustomAuthenticationEntryPoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;

@Configuration
@EnableWebFluxSecurity
public class WebSecurityConfig {
    private final JwtAuthConverter jwtAuthConverter;
    private final CustomAuthenticationEntryPoint customAuthenticationEntryPoint;
    private final CustomAccessDeniedHandler customAccessDeniedHandler;

    public WebSecurityConfig(JwtAuthConverter jwtAuthConverter, CustomAuthenticationEntryPoint customAuthenticationEntryPoint, CustomAccessDeniedHandler customAccessDeniedHandler) {
        this.jwtAuthConverter = jwtAuthConverter;
        this.customAuthenticationEntryPoint = customAuthenticationEntryPoint;
        this.customAccessDeniedHandler = customAccessDeniedHandler;
    }

    @Bean
    SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http) {
        http.exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((ServerAuthenticationEntryPoint)this.customAuthenticationEntryPoint).accessDeniedHandler((ServerAccessDeniedHandler)this.customAccessDeniedHandler)).authorizeExchange(authorize -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorize.pathMatchers(new String[]{"/actuator/info"})).permitAll().pathMatchers(new String[]{"/actuator/health"})).permitAll().pathMatchers(new String[]{"/webhook/tsa"})).permitAll().pathMatchers(new String[]{"/webhook/tsa/sendMessage/**"})).permitAll().pathMatchers(new String[]{"/webhook/tsa/conversationStatusChanged"})).permitAll().pathMatchers(new String[]{"/file/download/**"})).permitAll().anyExchange().authenticated()).oauth2ResourceServer(oauth2 -> oauth2.jwt(jwt -> jwt.jwtAuthenticationConverter((Converter)this.jwtAuthConverter))).csrf(ServerHttpSecurity.CsrfSpec::disable);
        return http.build();
    }
}

