/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.tsa.data.paginator.PaginadorResponse;
import com.agent.tsa.entity.views.ViewInteractionsReport;
import com.agent.tsa.repository.views.ViewInteractionsReportDAO;
import com.agent.tsa.service.InteractionReportService;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ViewInteractionsReportImpl
implements InteractionReportService {
    private final ViewInteractionsReportDAO interactionsReportDAO;

    public Mono<PaginadorResponse> getInteractionsReport(int page, int size, String initDate, String endDate) {
        Mono totalMono = this.interactionsReportDAO.countAll(initDate, endDate);
        return this.interactionsReportDAO.findAllByDatePaged(page, size, initDate, endDate).collectList().zipWith(totalMono, (data, total) -> {
            PaginadorResponse response = new PaginadorResponse();
            response.setContent(data);
            response.setTotalElements(Integer.valueOf(total.intValue()));
            response.setPage(Integer.valueOf(page));
            response.setSize(Integer.valueOf(size));
            int totalPages = (int)Math.ceil((double)total.longValue() / (double)size);
            response.setTotalPages(Integer.valueOf(totalPages > 0 ? totalPages - 1 : 0));
            return response;
        });
    }

    public Flux<ViewInteractionsReport> getInteractionsReport(String initDate, String endDate) {
        return this.interactionsReportDAO.findAllByDate(initDate, endDate).onErrorResume(e -> {
            System.err.println("Error fetching interactions report: " + e.getMessage());
            return Flux.empty();
        });
    }

    public ViewInteractionsReportImpl(ViewInteractionsReportDAO interactionsReportDAO) {
        this.interactionsReportDAO = interactionsReportDAO;
    }
}

