/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.client.tsa.schedule.TSAScheduleService;
import com.agent.client.tsa.schedule.models.TSAScheduleModel;
import com.agent.tsa.DTO.ScheduleDTO;
import com.agent.tsa.models.Schedules.ScheduleModel;
import com.agent.tsa.repository.ScheduleDAO;
import com.agent.tsa.repository.TeamDAO;
import com.agent.tsa.service.ScheduleService;
import com.agent.tsa.service.TeamService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    private TSAScheduleService tsaScheduleService;
    private TeamDAO teamDAO;
    private ScheduleDAO scheduleDAO;
    private TeamService teamService;

    public Mono<Void> saveSchedule(TSAScheduleModel tsaScheduleModel) {
        log.info("[TSA-Service] Iniciando guardado de horario para Callback ID: {}, Account ID: {}", (Object)tsaScheduleModel.getInbox_id(), (Object)tsaScheduleModel.getAccount_id());
        return this.teamDAO.findObjectIdByInboxId(String.valueOf(tsaScheduleModel.getAccount_id())).flatMap(inboxId -> Flux.fromIterable((Iterable)tsaScheduleModel.getWorking_hours()).map(data -> {
            log.info("llego");
            tsaScheduleModel.setInbox_id(inboxId);
            ScheduleModel model = new ScheduleModel();
            model.setDayOfWeek(data.getDay_of_week());
            model.setClosedAllDay(data.getClosed_all_day().booleanValue());
            model.setOpenHour(data.getOpen_hour());
            model.setOpenMinutes(data.getOpen_minutes());
            model.setCloseHour(data.getClose_hour());
            model.setCloseMinutes(data.getClose_minutes());
            model.setOpenAllDay(data.getOpen_all_day());
            model.setAccountId(tsaScheduleModel.getAccount_id());
            model.setCreatedAt(LocalDateTime.now());
            return model;
        }).flatMap(model -> {
            log.info("[TSA-Service] Guardando horario: D\u00eda={}, CerradoTodoElD\u00eda={}, Abre={}h:{}m, Cierra={}h:{}m, OpenAllDay={}, TeamID={}", new Object[]{model.getDayOfWeek(), model.isClosedAllDay(), model.getOpenHour(), model.getOpenMinutes(), model.getCloseHour(), model.getCloseMinutes(), model.getOpenAllDay(), model.getAccountId()});
            return this.scheduleDAO.save(model).doOnSuccess(saved -> log.info("[TSA-Service] Horario guardado exitosamente para el d\u00eda: {}", (Object)saved.getDayOfWeek())).doOnError(e -> log.error("[TSA-Service] Error al guardar horario para el d\u00eda: {}. Error: {}", (Object)model.getDayOfWeek(), (Object)e.getMessage()));
        }).then());
    }

    public Mono<Object> getSchedule(String account) {
        log.info("[TSA-Service] Iniciando obtenci\u00f3n de horario para Account ID: {}", (Object)account);
        return this.teamDAO.findObjectIdByInboxId(account).flatMap(inboxId -> this.tsaScheduleService.getSchedule(inboxId, account).doOnSuccess(schedule -> log.info("[TSA-Service] Obtenci\u00f3n exitosa del horario para Account ID: {}, Inbox ID: {}", (Object)account, inboxId)).doOnError(error -> log.error("[TSA-Service] Error al obtener horario para Account ID: {}, Inbox ID: {}. Error: {}", new Object[]{account, inboxId, error.getMessage(), error})));
    }

    public Mono<Object> getAllAgentByInbox(String account) {
        log.info("[TSA-Service] Iniciando obtenci\u00f3n de obtencion de agentes para Account ID: {}", (Object)account);
        return this.teamDAO.findObjectIdByInboxId(account).flatMap(inboxId -> this.tsaScheduleService.getAgentAllByInbox(inboxId, account).doOnSuccess(schedule -> log.info("[TSA-Service] Obtenci\u00f3n exitosa del obtencion de agentes para Account ID: {}, Inbox ID: {}", (Object)account, inboxId)).doOnError(error -> log.error("[TSA-Service] Error al obtener obtencion de agentes para Account ID: {}, Inbox ID: {}. Error: {}", new Object[]{account, inboxId, error.getMessage(), error})));
    }

    public Mono<List<ScheduleDTO>> getScheduleByDate(LocalDate initDate, LocalDate endDate, String account_id) {
        log.info("\ud83d\udccc [ScheduleService] Buscando schedules entre {} y {}", (Object)initDate, (Object)endDate);
        LocalDateTime startOfDay = initDate.atStartOfDay();
        LocalDateTime startOfNextDay = endDate.plusDays(1L).atStartOfDay();
        return this.scheduleDAO.getScheduleByDate(startOfDay, startOfNextDay, account_id).doOnSubscribe(sub -> log.debug("\ud83d\udd04 [ScheduleService] Iniciando consulta...")).doOnNext(schedule -> log.trace("\ud83d\udcc4 [ScheduleService] Encontrado: {}", schedule)).doOnComplete(() -> log.info("\u2705 [ScheduleService] Consulta completada")).doOnError(e -> log.error("\u274c [ScheduleService] Error en consulta", e)).collectList();
    }

    public ScheduleServiceImpl(TSAScheduleService tsaScheduleService, TeamDAO teamDAO, ScheduleDAO scheduleDAO, TeamService teamService) {
        this.tsaScheduleService = tsaScheduleService;
        this.teamDAO = teamDAO;
        this.scheduleDAO = scheduleDAO;
        this.teamService = teamService;
    }
}

