/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.repository;

import com.agent.tsa.DTO.ScheduleDTO;
import com.agent.tsa.models.Schedules.ScheduleModel;
import java.time.LocalDateTime;
import org.springframework.data.r2dbc.repository.Query;
import org.springframework.data.r2dbc.repository.R2dbcRepository;
import reactor.core.publisher.Flux;

public interface ScheduleDAO
extends R2dbcRepository<ScheduleModel, Long> {
    @Query(value="WITH date_range AS (\n           SELECT generate_series(\n               CAST(:initDate AS date),\n               CAST(:endDate AS date),\n               interval '1 day'\n           )::date AS target_date\n       ),\n       schedule_with_dates AS (\n           SELECT\n               d.target_date,  -- <<-- Campo de fecha a\u00f1adido\n               s.day_of_week,\n               s.closed_all_day,\n               s.open_hour,\n               s.open_minutes,\n               s.close_hour,\n               s.close_minutes,\n               s.open_all_day,\n               s.created_at,\n               s.account_id\n           FROM date_range d\n           LEFT JOIN LATERAL ( -- LEFT JOIN LATERAL (se puede usar ON TRUE)\n               SELECT DISTINCT ON (sc.account_id, sc.day_of_week)\n                   sc.day_of_week,\n                   sc.closed_all_day,\n                   sc.open_hour,\n                   sc.open_minutes,\n                   sc.close_hour,\n                   sc.close_minutes,\n                   sc.open_all_day,\n                   sc.created_at,\n                   sc.account_id\n               FROM lhia_service_agent.t_schedules sc\n               WHERE sc.account_id = :accountId\n               AND sc.day_of_week = EXTRACT(DOW FROM d.target_date)::int\n               AND sc.created_at <= d.target_date + interval '1 day' - interval '1 second'\n               ORDER BY sc.account_id, sc.day_of_week, sc.created_at DESC\n               LIMIT 1\n           ) s ON TRUE -- ON TRUE es permitido con LEFT JOIN LATERAL\n       )\n       SELECT *\n       FROM schedule_with_dates\n       WHERE account_id = :accountId\n       ORDER BY target_date, day_of_week\n")
    public Flux<ScheduleDTO> getScheduleByDate(LocalDateTime var1, LocalDateTime var2, String var3);
}

