/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.repository;

import com.agent.tsa.DTO.ObservationCountDTO;
import com.agent.tsa.entity.TInteractions;
import java.time.LocalDate;
import org.springframework.data.r2dbc.repository.Query;
import org.springframework.data.r2dbc.repository.R2dbcRepository;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface InteractionDAO
extends R2dbcRepository<TInteractions, Long> {
    @Query(value="SELECT COUNT(*) AS total FROM lhia_service_agent.t_interactions ti WHERE ti.created_at >= :initDate   AND ti.created_at <  :endDate")
    public Mono<Long> countInteractionsByDateRange(LocalDate var1, LocalDate var2);

    @Query(value="SELECT COUNT(DISTINCT ti.phone)FROM lhia_service_agent.t_interactions ti WHERE ti.created_at >= :initDate   AND ti.created_at <  :endDate")
    public Mono<Long> countDistinctPhonesByDateRange(LocalDate var1, LocalDate var2);

    @Query(value="             SELECT\n             split_part(ti.observations, ',', 2) AS observacion,\n             COUNT(*)                            AS total\n             FROM lhia_service_agent.t_interactions ti\n             WHERE ti.created_at >= :initDate\n             AND ti.created_at <  :endDate\n             GROUP BY split_part(ti.observations, ',', 2)\n             ORDER BY total DESC\n")
    public Flux<ObservationCountDTO> countObservationsByDateRange(LocalDate var1, LocalDate var2);
}

