/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.repository;

import com.agent.tsa.DTO.ConversationLabelsCountDTO;
import com.agent.tsa.DTO.ConversationsCountDTO;
import com.agent.tsa.entity.TConversation;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.springframework.data.r2dbc.repository.Modifying;
import org.springframework.data.r2dbc.repository.Query;
import org.springframework.data.r2dbc.repository.R2dbcRepository;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ConversationDAO
extends R2dbcRepository<TConversation, Long> {
    @Query(value="SELECT sync_labels(:conversationId, :accountId, :labels)")
    public Mono<String> syncLabels(Long var1, String var2, String[] var3);

    @Modifying
    @Query(value="INSERT INTO t_conversation (\n    conversation_id, agent_id, inbox_id, team_id, contact_id, account_id, status, callback_url, created_at, updated_at, first_reply_created_at\n) VALUES (\n    :conversationId, :agentId, :inboxId, :teamId, :contactId, :accountId, :status, :callbackUrl, :createdAt, :updatedAt, :firstReplyCreatedAt\n)\nON CONFLICT (conversation_id, account_id) DO UPDATE SET\n    inbox_id = EXCLUDED.inbox_id,\n\tagent_id = EXCLUDED.agent_id,\n    team_id = EXCLUDED.team_id,\n    contact_id = EXCLUDED.contact_id,\n    account_id = EXCLUDED.account_id,\n    status = EXCLUDED.status,\n    callback_url = EXCLUDED.callback_url,\n    updated_at = EXCLUDED.updated_at,\n\tfirst_reply_created_at = EXCLUDED.first_reply_created_at\n")
    public Mono<Void> upsert(Long var1, Long var2, Long var3, Long var4, Long var5, String var6, String var7, String var8, LocalDateTime var9, LocalDateTime var10, LocalDateTime var11);

    public Mono<TConversation> findByConversationIdAndAccountId(Long var1, String var2);

    @Query(value="select agent_id from t_conversation tc inner join t_contact tcon on tc.contact_id = tcon.id inner join t_team tt on tc.team_id = tt.team_id  where tc.account_id = :accountId and tt.team_id = :teamId and tcon.id_tsa = :contactId order by tc.created_at desc limit 1")
    public Mono<Long> getLastAssignedIdFromConversationByContactIdAndTeamId(String var1, Long var2, Long var3);

    @Query(value="SELECT tcv.* FROM t_conversation tcv INNER JOIN t_contact tc ON tcv.contact_id = tc.id WHERE REPLACE(tc.identifier, '+', '') = :identifier AND tcv.account_id = :accountId AND tcv.status <> :status ORDER BY tcv.created_at DESC LIMIT 1")
    public Mono<TConversation> findConversationByIdentifierAndStatusAndAccountId(String var1, String var2, String var3);

    @Query(value="SELECT tcv.callback_url FROM t_conversation tcv WHERE tcv.conversation_id = :convId AND tcv.account_id = :accountId")
    public Mono<String> findCallbackUrlByConversationIdAndAccountId(Long var1, String var2);

    @Query(value="SELECT CASE WHEN COUNT(tc.id) = 0 THEN 'N' WHEN MAX(tc.status) = 'resolved' THEN 'I' WHEN MAX(tc.created_at) >= NOW() - INTERVAL '48 HOURS' THEN 'V' ELSE 'I' END AS conversation_status FROM t_conversation tc WHERE tc.conversation_id = :conversationId AND tc.account_id = :accountId")
    public Mono<String> isValidConversationByConversationIdAndAccountId(Long var1, String var2);

    @Modifying
    @Query(value="UPDATE t_conversation SET status = :status WHERE conversation_id = :conversationId AND account_id = :accountId")
    public Mono<Integer> updateStatusByConversationIdAndAccountId(Long var1, String var2, String var3);

    @Query(value="SELECT tc.* FROM t_conversation tc WHERE tc.created_at <= NOW() - INTERVAL '48 HOURS' AND tc.first_reply_created_at is not null AND tc.status <> 'resolved'")
    public Flux<TConversation> findAllConversationsToClose();

    @Query(value="SELECT tc.* FROM t_conversation tc WHERE tc.created_at <= NOW() - INTERVAL '24 HOURS' AND tc.first_reply_created_at IS NULL AND tc.status <> 'resolved' AND tc.notified_tsa_actions = false")
    public Flux<TConversation> findAllConversationsNotClosedToSetTagsOnTsa();

    @Modifying
    @Query(value="UPDATE t_conversation SET notified_tsa_actions = true WHERE id = :conversationTwsId")
    public Mono<Integer> updateActionsTsaTagsByConversationTwsId(Long var1);

    @Query(value="SELECT tc.identifier FROM t_conversation tcv INNER JOIN t_contact tc ON tcv.contact_id = tc.id WHERE tcv.conversation_id = :conversationId AND tcv.account_id = :accountId")
    public Mono<String> findIdentifierByConversationIdAndAccountId(Long var1, String var2);

    @Query(value="SELECT COUNT(*) AS total, DATE(created_at) AS date FROM t_conversation WHERE created_at >= :initDate AND created_at <= :endDate AND account_id = :accountId GROUP BY DATE(created_at) ORDER BY date ASC")
    public Flux<ConversationsCountDTO> countConversationsByDateAndAccountId(LocalDateTime var1, LocalDateTime var2, String var3);

    @Query(value="SELECT label as label, created_at::date AS fecha,  COUNT(*) AS cantidad FROM lhia_service_agent.t_conversation_labels WHERE account_id = :accountId AND created_at::date BETWEEN :initDate AND :endDate GROUP BY label, created_at::date ORDER BY label, fecha asc")
    public Flux<ConversationLabelsCountDTO> findConversationLabelsCountByDateAndAccountId(LocalDate var1, LocalDate var2, String var3);
}

