/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.data;

import com.agent.tsa.data.RequestMessageModel;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;

public class RequestMessageModel {
    @NotBlank(message="El ID no puede estar vac\u00edo")
    @Size(min=5, max=50, message="El ID debe tener entre 5 y 50 caracteres")
    private @NotBlank(message="El ID no puede estar vac\u00edo") @Size(min=5, max=50, message="El ID debe tener entre 5 y 50 caracteres") String id;
    @NotBlank(message="El callbackUrl no puede estar vac\u00edo")
    @Pattern(regexp="^(http|https)://.*$", message="El callbackUrl debe ser una URL v\u00e1lida")
    private @NotBlank(message="El callbackUrl no puede estar vac\u00edo") @Pattern(regexp="^(http|https)://.*$", message="El callbackUrl debe ser una URL v\u00e1lida") String callbackUrl;
    @NotBlank(message="El tipo no puede estar vac\u00edo")
    private @NotBlank(message="El tipo no puede estar vac\u00edo") String type;
    @NotBlank(message="El canal no puede estar vac\u00edo")
    private @NotBlank(message="El canal no puede estar vac\u00edo") String channel;
    @NotBlank(message="El nick no puede estar vac\u00edo")
    private @NotBlank(message="El nick no puede estar vac\u00edo") String nick;
    private Boolean ignoreInitMessage;
    @NotNull(message="El payload no puede ser nulo")
    @Valid
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull(message="El payload no puede ser nulo") @Valid RequestMessageModel.Payload payload;
    private String agentUsername;

    public static RequestMessageModel createFullMessage(String id, Long idTsaMessage, Long idTsaMessageReplied, String type, String messageType, String content, String repliedMessage, String nick, String agentUsername) {
        Payload payload = new Payload(idTsaMessage, idTsaMessageReplied, messageType, content, repliedMessage);
        return new RequestMessageModel(id, type, nick, payload, agentUsername);
    }

    private RequestMessageModel(String id, String type, String nick, Payload payload, String agentUsername) {
        this.id = id;
        this.type = type;
        this.nick = nick;
        this.payload = payload;
        this.agentUsername = agentUsername;
    }

    public static RequestMessageModel createTextMessage(String id, String type, String messageType, String content, String nick, String agentUsername) {
        Payload payload = new Payload(null, null, messageType, content, null);
        return new RequestMessageModel(id, type, nick, payload, agentUsername);
    }

    public static RequestMessageModel createTemplateMessage(String id, Long idTsaMessage, Long idTsaMessageReplied, String type, String messageType, String content, String nick, String agentUsername) {
        Payload payload = new Payload(idTsaMessage, idTsaMessageReplied, messageType, content, null);
        return new RequestMessageModel(id, type, nick, payload, agentUsername);
    }

    public String getId() {
        return this.id;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getType() {
        return this.type;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getNick() {
        return this.nick;
    }

    public Boolean getIgnoreInitMessage() {
        return this.ignoreInitMessage;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public String getAgentUsername() {
        return this.agentUsername;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public void setIgnoreInitMessage(Boolean ignoreInitMessage) {
        this.ignoreInitMessage = ignoreInitMessage;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public void setAgentUsername(String agentUsername) {
        this.agentUsername = agentUsername;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestMessageModel)) {
            return false;
        }
        RequestMessageModel other = (RequestMessageModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$ignoreInitMessage = this.getIgnoreInitMessage();
        Boolean other$ignoreInitMessage = other.getIgnoreInitMessage();
        if (this$ignoreInitMessage == null ? other$ignoreInitMessage != null : !((Object)this$ignoreInitMessage).equals(other$ignoreInitMessage)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$callbackUrl = this.getCallbackUrl();
        String other$callbackUrl = other.getCallbackUrl();
        if (this$callbackUrl == null ? other$callbackUrl != null : !this$callbackUrl.equals(other$callbackUrl)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        String this$nick = this.getNick();
        String other$nick = other.getNick();
        if (this$nick == null ? other$nick != null : !this$nick.equals(other$nick)) {
            return false;
        }
        Payload this$payload = this.getPayload();
        Payload other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        String this$agentUsername = this.getAgentUsername();
        String other$agentUsername = other.getAgentUsername();
        return !(this$agentUsername == null ? other$agentUsername != null : !this$agentUsername.equals(other$agentUsername));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestMessageModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ignoreInitMessage = this.getIgnoreInitMessage();
        result = result * 59 + ($ignoreInitMessage == null ? 43 : ((Object)$ignoreInitMessage).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $callbackUrl = this.getCallbackUrl();
        result = result * 59 + ($callbackUrl == null ? 43 : $callbackUrl.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        String $nick = this.getNick();
        result = result * 59 + ($nick == null ? 43 : $nick.hashCode());
        Payload $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        String $agentUsername = this.getAgentUsername();
        result = result * 59 + ($agentUsername == null ? 43 : $agentUsername.hashCode());
        return result;
    }

    public String toString() {
        return "RequestMessageModel(id=" + this.getId() + ", callbackUrl=" + this.getCallbackUrl() + ", type=" + this.getType() + ", channel=" + this.getChannel() + ", nick=" + this.getNick() + ", ignoreInitMessage=" + this.getIgnoreInitMessage() + ", payload=" + this.getPayload() + ", agentUsername=" + this.getAgentUsername() + ")";
    }

    public RequestMessageModel() {
    }
}

