/*
 * Decompiled with CFR 0.152.
 */
package com.agent.strategy.messagestsa.implement;

import com.agent.client.tsa.message.service.TsaMessageService;
import com.agent.strategy.messagestsa.MessageTsaStrategy;
import com.agent.tsa.DTO.MessageRequestDTO;
import com.agent.tsa.data.conversation.messages.CallbackTsaMessage;
import com.agent.tsa.models.conversation.TextMessage;
import com.agent.tsa.utils.TemplateMessage;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class TextMessageStrategy
implements MessageTsaStrategy {
    private final TsaMessageService messageSenderService;

    public TextMessageStrategy(TsaMessageService messageSenderService) {
        this.messageSenderService = messageSenderService;
    }

    public String getType() {
        return "text";
    }

    public Mono<CallbackTsaMessage> handle(MessageRequestDTO request) {
        boolean hasRepliedMessage = request.getRepliedMessageContent() != null;
        String newMessage = hasRepliedMessage ? TemplateMessage.messageBuilded((String)request.getRepliedMessageContent(), (String)request.getContent()) : request.getContent();
        TextMessage textMessage = new TextMessage();
        textMessage.setMessageType("incoming");
        textMessage.setContent(newMessage);
        textMessage.setPrivate(false);
        textMessage.setContentType("text");
        return this.messageSenderService.sendMesssageToTSA(textMessage, request.getConversationId(), request.getAccountId());
    }
}

