/*
 * Decompiled with CFR 0.152.
 */
package com.agent.strategy.messagestsa.factory;

import com.agent.exceptions.CustomException;
import com.agent.strategy.messagestsa.MessageTsaStrategy;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class MessageStrategyFactory {
    private final Map<String, MessageTsaStrategy> strategies;

    public MessageStrategyFactory(List<MessageTsaStrategy> strategyList) {
        this.strategies = strategyList.stream().collect(Collectors.toMap(MessageTsaStrategy::getType, Function.identity()));
    }

    public MessageTsaStrategy getStrategy(String type) {
        MessageTsaStrategy strategy = (MessageTsaStrategy)this.strategies.get(type);
        if (strategy == null) {
            throw new CustomException("Tipo de mensaje no soportado: " + type, HttpStatus.BAD_REQUEST);
        }
        return strategy;
    }
}

