/*
 * Decompiled with CFR 0.152.
 */
package com.agent.controller;

import com.agent.client.tsa.schedule.models.TSAScheduleModel;
import com.agent.tsa.DTO.RequestReportTimeResponseDTO;
import com.agent.tsa.DTO.ScheduleDTO;
import com.agent.tsa.service.ScheduleService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/schedules"})
public class SchedulesController {
    private static final Logger log = LoggerFactory.getLogger(SchedulesController.class);
    private ScheduleService scheduleService;

    @PostMapping(value={""})
    public Mono<ResponseEntity<String>> saveSchedule(@RequestBody TSAScheduleModel tsaScheduleModel) {
        log.info("[TSA] Inicio de actualizaci\u00f3n de horario. Datos recibidos: {}", (Object)tsaScheduleModel);
        return this.scheduleService.saveSchedule(tsaScheduleModel).doOnSubscribe(subscription -> log.debug("[TSA] Proceso de guardado iniciado para Account ID: {}, Inbox ID: {}", (Object)tsaScheduleModel.getInbox_id(), (Object)tsaScheduleModel.getAccount_id())).doOnSuccess(unused -> log.info("[TSA] Guardado exitoso del horario para Account ID: {}, Inbox ID: {}", (Object)tsaScheduleModel.getInbox_id(), (Object)tsaScheduleModel.getAccount_id())).doOnError(error -> log.error("[TSA] Error al guardar el horario para Account ID: {}, Inbox ID: {}. Error: {}", new Object[]{tsaScheduleModel.getInbox_id(), tsaScheduleModel.getAccount_id(), error.getMessage(), error})).then(Mono.just((Object)ResponseEntity.ok((Object)"Update Schedules")));
    }

    @GetMapping(value={"/{account}"})
    public Mono<ResponseEntity<Object>> getSchedule(@PathVariable String account) {
        log.info("[TSA] Inicio de actualizaci\u00f3n de horario. Datos recibidos: {}", (Object)account);
        return this.scheduleService.getSchedule(account).doOnSubscribe(subscription -> log.debug("[TSA] Proceso de guardado iniciado para Account ID: {}", (Object)account)).doOnSuccess(unused -> log.info("[TSA] Guardado exitoso del horario para Account ID: {}", (Object)account)).doOnError(error -> log.error("[TSA] Error al guardar el horario para Account ID: {}. Error: {}", new Object[]{account, error.getMessage(), error})).map(result -> ResponseEntity.ok().body(result));
    }

    @GetMapping(value={"/all_agent_inbox/{account}"})
    public Mono<ResponseEntity<Object>> getAllAgentByInbox(@PathVariable String account) {
        log.info("[TSA] Inicio de obtencion de agentes. Datos recibidos: {}", (Object)account);
        return this.scheduleService.getAllAgentByInbox(account).doOnSubscribe(subscription -> log.debug("[TSA] Proceso de obtencion de agentes iniciado para Account ID: {}", (Object)account)).doOnSuccess(unused -> log.info("[TSA] obtencion de agentes exitoso para Account ID: {}", (Object)account)).doOnError(error -> log.error("[TSA] Error al obtencion de agentes para Account ID: {}. Error: {}", new Object[]{account, error.getMessage(), error})).map(result -> ResponseEntity.ok().body(result));
    }

    @PostMapping(value={"/time-response/{account_id}"})
    public ResponseEntity<Mono<List<ScheduleDTO>>> getDataTimeResponse(@RequestBody RequestReportTimeResponseDTO body, @PathVariable String account_id) {
        log.info("\ud83d\udce5 [ReportsController] Recibiendo request /time-response: initDate={}, endDate={}", (Object)body.getInitDate(), (Object)body.getEndDate());
        Mono flux = this.scheduleService.getScheduleByDate(body.getInitDate(), body.getEndDate(), account_id).doOnSubscribe(sub -> log.info("\u27a1\ufe0f [ReportsController] Consultando horarios en BD...")).doOnNext(schedule -> log.debug("\ud83d\udd0e [ReportsController] Registro recibido: {}", schedule)).doOnError(e -> log.error("\u274c [ReportsController] Error obteniendo schedules", e));
        return ResponseEntity.ok((Object)flux);
    }

    public SchedulesController(ScheduleService scheduleService) {
        this.scheduleService = scheduleService;
    }
}

