/*
 * Decompiled with CFR 0.152.
 */
package com.agent.controller;

import com.agent.auto.ScheduleConfig;
import com.agent.tsa.DTO.RequestChatDTO;
import com.agent.tsa.service.RoundRobinAssignmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"api/ms/assignChats"})
public class AssignChatsController {
    private static final Logger log = LoggerFactory.getLogger(AssignChatsController.class);
    private final RoundRobinAssignmentService assignmentService;
    private final ScheduleConfig config;

    @GetMapping(value={"/conversations"})
    public Mono<String> autoAssignConversations() {
        log.info("Asignacion desde el controlador");
        for (Long companyId : this.config.getCompanyIds()) {
            log.info("\u23f1 (MANUAL) Ejecutando asignaci\u00f3n para empresa ID: {}", (Object)companyId);
            this.assignmentService.assignConversationsV2(companyId.toString()).subscribe();
        }
        return Mono.just((Object)"Asignacion Completada");
    }

    @PostMapping(path={"/company"}, consumes={"application/json"}, produces={"text/plain"})
    public Mono<String> autoAssignConversationsByCompanyId(@RequestBody RequestChatDTO request) {
        String companyId = request.getIdCompany();
        log.info("Asignaci\u00f3n manual para empresa ID: {}", (Object)companyId);
        return this.assignmentService.assignConversations(companyId.toString()).then(Mono.just((Object)("Asignaci\u00f3n completada para empresa ID: " + companyId)));
    }

    @PostMapping(path={"/companyV3"}, consumes={"application/json"}, produces={"text/plain"})
    public Mono<String> autoAssignConversationsByCompanyIdV3(@RequestBody RequestChatDTO request) {
        String companyId = request.getIdCompany();
        log.info("Asignaci\u00f3n manual para empresa ID: {}", (Object)companyId);
        return this.assignmentService.assignConversationsV3(companyId.toString()).then(Mono.just((Object)("Asignaci\u00f3n completada para empresa ID: " + companyId)));
    }

    public AssignChatsController(RoundRobinAssignmentService assignmentService, ScheduleConfig config) {
        this.assignmentService = assignmentService;
        this.config = config;
    }
}

