/*
 * Decompiled with CFR 0.152.
 */
package com.agent.client.tsa.conversation.service;

import com.agent.client.tsa.conversation.models.AssignConversationDTO;
import com.agent.client.tsa.conversation.models.ConversationsNotAssigned.ConversationDataNotAssigned;
import com.agent.client.tsa.conversation.models.LabelsModel;
import com.agent.client.tsa.conversation.models.PriorityModel;
import com.agent.client.tsa.conversation.service.TsaConversationApiService.TsaConversationApiService;
import com.agent.tsa.data.conversation.Conversation;
import com.agent.tsa.models.conversation.CreateConversationModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class TsaConversationApiServiceImpl
implements TsaConversationApiService {
    private static final Logger log = LoggerFactory.getLogger(TsaConversationApiServiceImpl.class);
    private final WebClient.Builder webClient;
    private final ObjectMapper objectMapper;
    private final Environment env;

    public Mono<Conversation> createNewConversationTSA(CreateConversationModel conversationModel, String accountId) {
        String API_URL = this.env.getProperty("tsa.api.conversation.create").replace("{account_id}", accountId);
        String token = this.env.getProperty("tsa.api.token");
        log.info(API_URL);
        log.info("REQUEST TO TSA {}", (Object)conversationModel);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("api_access_token", token);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue((Object)conversationModel).retrieve().bodyToMono(Conversation.class).flatMap(response -> {
            log.info("response tsa {}", response);
            return Mono.just((Object)response);
        });
    }

    public Mono<String> toggleStatusConversation(Long conversationId, String newStatus, String accountId) {
        String API_URL = this.env.getProperty("tsa.api.conversation.status").replace("{conversation_id}", conversationId.toString()).replace("{account_id}", accountId);
        String token = this.env.getProperty("tsa.api.token");
        log.info(API_URL);
        ObjectNode body = this.objectMapper.createObjectNode();
        body.put("status", newStatus);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("api_access_token", token);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue((Object)body).retrieve().bodyToMono(String.class).flatMap(response -> {
            log.info("response tsa {}", response);
            return Mono.just((Object)response);
        });
    }

    public Mono<String> addLabelsToConversation(Long conversationId, List<String> labels, String accountId) {
        LabelsModel labelsModel = new LabelsModel(labels);
        String API_URL = this.env.getProperty("tsa.api.conversation.labels").replace("{conversation_id}", conversationId.toString()).replace("{account_id}", accountId);
        String token = this.env.getProperty("tsa.api.token");
        log.info("REQUEST TO TSA LABELS: conversation {}, labels {}, api", new Object[]{conversationId, labelsModel, API_URL});
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("api_access_token", token);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue((Object)labelsModel).retrieve().bodyToMono(String.class).flatMap(response -> {
            log.info("response tsa add labels {}", response);
            return Mono.just((Object)response);
        });
    }

    public Mono<String> togglePriorityConversation(Long conversationId, String prioriry, String accountId) {
        PriorityModel priorityModel = new PriorityModel(prioriry);
        String API_URL = this.env.getProperty("tsa.api.conversation.priority").replace("{conversation_id}", conversationId.toString()).replace("{account_id}", accountId);
        String token = this.env.getProperty("tsa.api.token");
        log.info("REQUEST TO TSA LABELS: conversation {}, priority {}, api {}", new Object[]{conversationId, priorityModel, API_URL});
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("api_access_token", token);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue((Object)priorityModel).retrieve().bodyToMono(String.class).flatMap(response -> {
            log.info("response tsa toggle priority {}", response);
            return Mono.just((Object)response);
        });
    }

    public Mono<ConversationDataNotAssigned> getListConversationsNotAssigned(String accountId) {
        String API_URL = this.env.getProperty("tsa.api.conversation.not_assigned").replace("{account_id}", accountId);
        String token = this.env.getProperty("tsa.api.token");
        log.info("REQUEST TO TSA NOT ASSIGNED {}", (Object)API_URL);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("api_access_token", token);
        return this.webClient.build().get().uri(API_URL, new Object[0]).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers)).retrieve().bodyToMono(ConversationDataNotAssigned.class).flatMap(response -> {
            log.info("response tsa {}", response);
            return Mono.just((Object)response);
        });
    }

    public Mono<String> assignConversation(Long conversationId, String accountId, AssignConversationDTO assignConversationDTO) {
        String API_URL = this.env.getProperty("tsa.api.conversation.assign").replace("{conversation_id}", conversationId.toString()).replace("{account_id}", accountId);
        String token = this.env.getProperty("tsa.api.token");
        log.info("REQUEST TO ASIGN CONVERSATION: conversation {}, accountid {}, api {}", new Object[]{conversationId, accountId, API_URL});
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("api_access_token", token);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue((Object)assignConversationDTO).retrieve().bodyToMono(String.class).flatMap(response -> {
            log.info("response tsa assigned conversation {}", response);
            return Mono.just((Object)response);
        });
    }

    public WebClient.Builder getWebClient() {
        return this.webClient;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Environment getEnv() {
        return this.env;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsaConversationApiServiceImpl)) {
            return false;
        }
        TsaConversationApiServiceImpl other = (TsaConversationApiServiceImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        WebClient.Builder this$webClient = this.getWebClient();
        WebClient.Builder other$webClient = other.getWebClient();
        if (this$webClient == null ? other$webClient != null : !this$webClient.equals(other$webClient)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !this$env.equals(other$env));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TsaConversationApiServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebClient.Builder $webClient = this.getWebClient();
        result = result * 59 + ($webClient == null ? 43 : $webClient.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        return result;
    }

    public String toString() {
        return "TsaConversationApiServiceImpl(webClient=" + this.getWebClient() + ", objectMapper=" + this.getObjectMapper() + ", env=" + this.getEnv() + ")";
    }

    public TsaConversationApiServiceImpl(WebClient.Builder webClient, ObjectMapper objectMapper, Environment env) {
        this.webClient = webClient;
        this.objectMapper = objectMapper;
        this.env = env;
    }
}

