/*
 * Decompiled with CFR 0.152.
 */
package com.agent.auto;

import com.agent.auto.ScheduleConfig;
import com.agent.tsa.service.RoundRobinAssignmentService;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AutoAssignScheduler {
    private static final Logger log = LoggerFactory.getLogger(AutoAssignScheduler.class);
    private final RoundRobinAssignmentService assignmentService;
    private final ScheduleConfig config;

    public AutoAssignScheduler(RoundRobinAssignmentService assignmentService, ScheduleConfig config) {
        this.assignmentService = assignmentService;
        this.config = config;
    }

    @Scheduled(cron="0 45 7 * * MON-FRI", zone="America/Guayaquil")
    @SchedulerLock(name="autoAssignWeekdays", lockAtLeastFor="10m", lockAtMostFor="30m")
    public void assignWeekdays() {
        for (Long companyId : this.config.getCompanyIds()) {
            log.info("\u23f1 (First Task Execute) Ejecutando asignaci\u00f3n para empresa ID: {}", (Object)companyId);
            this.assignmentService.assignConversations(companyId.toString()).subscribe();
        }
    }

    @Scheduled(cron="0 15 8 * * SAT", zone="America/Guayaquil")
    @SchedulerLock(name="autoAssignSaturday", lockAtLeastFor="10m", lockAtMostFor="30m")
    public void assignSaturday() {
        for (Long companyId : this.config.getCompanyIds()) {
            log.info("\u23f1 (First Task Execute) Ejecutando asignaci\u00f3n para empresa ID: {}", (Object)companyId);
            this.assignmentService.assignConversations(companyId.toString()).subscribe();
        }
    }

    @Scheduled(cron="0 15 9 * * SUN", zone="America/Guayaquil")
    @SchedulerLock(name="autoAssignSunday", lockAtLeastFor="10m", lockAtMostFor="30m")
    public void assignSunday() {
        for (Long companyId : this.config.getCompanyIds()) {
            log.info("\u23f1 (First Task Execute) Ejecutando asignaci\u00f3n para empresa ID: {}", (Object)companyId);
            this.assignmentService.assignConversations(companyId.toString()).subscribe();
        }
    }

    @Scheduled(cron="0 0 8 * * MON-FRI", zone="America/Guayaquil")
    @SchedulerLock(name="autoAssignWeekdaysV2", lockAtLeastFor="10m", lockAtMostFor="30m")
    public void assignWeekdaysV2() {
        for (Long companyId : this.config.getCompanyIds()) {
            log.info("\u23f1 (Second Task Execute) Ejecutando asignaci\u00f3n para empresa ID: {}", (Object)companyId);
            this.assignmentService.assignConversations(companyId.toString()).subscribe();
        }
    }

    @Scheduled(cron="0 30 8 * * SAT", zone="America/Guayaquil")
    @SchedulerLock(name="autoAssignSaturdayV2", lockAtLeastFor="10m", lockAtMostFor="30m")
    public void assignSaturdayV2() {
        for (Long companyId : this.config.getCompanyIds()) {
            log.info("\u23f1 (Second Task Execute) Ejecutando asignaci\u00f3n para empresa ID: {}", (Object)companyId);
            this.assignmentService.assignConversations(companyId.toString()).subscribe();
        }
    }

    @Scheduled(cron="0 30 9 * * SUN", zone="America/Guayaquil")
    @SchedulerLock(name="autoAssignSundayV2", lockAtLeastFor="10m", lockAtMostFor="30m")
    public void assignSundayV2() {
        for (Long companyId : this.config.getCompanyIds()) {
            log.info("\u23f1 (Second Task Execute) Ejecutando asignaci\u00f3n para empresa ID: {}", (Object)companyId);
            this.assignmentService.assignConversations(companyId.toString()).subscribe();
        }
    }
}

