/*
 * Decompiled with CFR 0.152.
 */
package com.tws.lhiavoice.service.impl;

import com.tws.lhiavoice.models.dto.ConversacionDTO;
import com.tws.lhiavoice.models.dto.InteraccionDTO;
import com.tws.lhiavoice.models.view.MensajeView;
import com.tws.lhiavoice.repository.TMensajeDAO;
import com.tws.lhiavoice.service.TMensajeService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class TMensajeServiceImpl
implements TMensajeService {
    private final TMensajeDAO mensajeDAO;

    public List<ConversacionDTO> obtenerConversacionesPorFecha(LocalDateTime desde, LocalDateTime hasta) {
        List mensajes = this.mensajeDAO.findMensajesPorFechas(desde, hasta);
        LinkedHashMap agrupado = new LinkedHashMap();
        for (MensajeView mensaje : mensajes) {
            Long idConversacion = mensaje.getIdConversacion();
            String interaction = mensaje.getInteraction();
            agrupado.putIfAbsent(idConversacion, new LinkedHashMap());
            Map interacciones = (Map)agrupado.get(idConversacion);
            interacciones.putIfAbsent(interaction, new InteraccionDTO(interaction));
            InteraccionDTO dto = (InteraccionDTO)interacciones.get(interaction);
            if ("usuario".equalsIgnoreCase(mensaje.getRemitente())) {
                dto.setUsuario(mensaje);
                continue;
            }
            if (!"assistant".equalsIgnoreCase(mensaje.getRemitente())) continue;
            dto.setAssistant(mensaje);
        }
        ArrayList<ConversacionDTO> resultado = new ArrayList<ConversacionDTO>();
        for (Map.Entry entry : agrupado.entrySet()) {
            ConversacionDTO conversacion = new ConversacionDTO((Long)entry.getKey());
            conversacion.getInteracciones().addAll(((Map)entry.getValue()).values());
            resultado.add(conversacion);
        }
        return resultado;
    }

    @Generated
    public TMensajeServiceImpl(TMensajeDAO mensajeDAO) {
        this.mensajeDAO = mensajeDAO;
    }
}

