/*
 * Decompiled with CFR 0.152.
 */
package com.tws.lhiavoice.service.impl;

import com.tws.lhiavoice.models.TConversacion;
import com.tws.lhiavoice.models.TMensaje;
import com.tws.lhiavoice.models.request.MensajeRequest;
import com.tws.lhiavoice.repository.TConversacionDAO;
import com.tws.lhiavoice.repository.TMensajeDAO;
import com.tws.lhiavoice.service.TConversacionService;
import com.tws.lhiavoice.utils.ApiResponse;
import java.time.LocalDateTime;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TConversacionServiceImpl
implements TConversacionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TConversacionServiceImpl.class);
    private final TConversacionDAO conversacionDAO;
    private final TMensajeDAO mensajeDAO;

    public ApiResponse<TMensaje> agregarMensaje(MensajeRequest request) {
        boolean duplicado;
        TConversacion conversacion = this.conversacionDAO.findByConversationId(request.getConversationId());
        if (conversacion == null) {
            conversacion = new TConversacion();
            conversacion.setConversationId(request.getConversationId());
            conversacion.setFechaInicio(LocalDateTime.now());
            conversacion.setUsuarioId("desconocido");
            conversacion.setCanalOrigen(request.getCanal());
            conversacion.setRecording(request.getGrabacion());
            conversacion.setEstado(request.getStatus());
            conversacion = (TConversacion)this.conversacionDAO.save((Object)conversacion);
        }
        if (duplicado = this.mensajeDAO.existsByConversacion(request.getConversationId(), request.getRemitente(), request.getInteraction())) {
            return ApiResponse.error((int)409, (String)"Interacci\u00f3n ya registrada");
        }
        TMensaje mensaje = new TMensaje();
        mensaje.setConversacion(conversacion);
        mensaje.setRemitente(request.getRemitente());
        mensaje.setMensaje(request.getMensaje());
        mensaje.setTipoMensaje(request.getTipoMensaje());
        mensaje.setFechaRegistro(LocalDateTime.now());
        mensaje.setCallerId(request.getCallerId());
        mensaje.setExten(request.getExten());
        mensaje.setInteraction(request.getInteraction());
        TMensaje guardado = (TMensaje)this.mensajeDAO.save((Object)mensaje);
        return ApiResponse.success((String)"Mensaje registrado", (Object)guardado);
    }

    @Generated
    public TConversacionServiceImpl(TConversacionDAO conversacionDAO, TMensajeDAO mensajeDAO) {
        this.conversacionDAO = conversacionDAO;
        this.mensajeDAO = mensajeDAO;
    }
}

