/*
 * Decompiled with CFR 0.152.
 */
package com.tws.lhiavoice.service.impl;

import com.tws.lhiavoice.models.TCompromisoPago;
import com.tws.lhiavoice.models.TConversacion;
import com.tws.lhiavoice.models.TSummaryConversacion;
import com.tws.lhiavoice.models.dto.CompromisoPagoDTO;
import com.tws.lhiavoice.models.dto.SumaryResultadoDTO;
import com.tws.lhiavoice.repository.TCompromisoPagoDAO;
import com.tws.lhiavoice.repository.TConversacionDAO;
import com.tws.lhiavoice.repository.TMensajeDAO;
import com.tws.lhiavoice.repository.TSumaryConversacionDAO;
import com.tws.lhiavoice.service.IAService;
import com.tws.lhiavoice.service.SumaryConversacionService;
import com.tws.lhiavoice.utils.PromptUtils;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class SumaryConversacionServiceImpl
implements SumaryConversacionService {
    private final TConversacionDAO conversacionDAO;
    private final TMensajeDAO mensajeDAO;
    private final TSumaryConversacionDAO sumaryDAO;
    private final IAService chatapiService;
    private final TCompromisoPagoDAO compromisoPagoDAO;

    @Scheduled(fixedRate=360000L)
    public void ejecutarScheduler() {
        this.procesarConversacionesPendientes();
    }

    @Transactional
    public void procesarConversacionesPendientes() {
        List conversaciones = this.conversacionDAO.findByStatusSumaryFalse();
        LocalDateTime ahora = LocalDateTime.now();
        LocalDateTime hace24Horas = ahora.minusHours(24L);
        for (TConversacion conv : conversaciones) {
            List mensajes = this.mensajeDAO.findByConversacionIdAndFechaRegistroBetween(conv.getId(), hace24Horas, ahora);
            if (mensajes.isEmpty()) continue;
            String texto = mensajes.stream().map(m -> m.getRemitente() + ": " + m.getMensaje()).collect(Collectors.joining("\n"));
            String prompt = PromptUtils.PROMPT_RESUMEN_CONVERSACION((String)texto);
            SumaryResultadoDTO resumenGenerado = this.chatapiService.GenerateSumaryDAO(prompt);
            Optional existente = this.sumaryDAO.findByConversacionIdAndFechaRegistroBetween(conv.getId(), hace24Horas, ahora);
            if (existente.isPresent()) {
                this.actualizarResumen((TSummaryConversacion)existente.get(), resumenGenerado);
            } else {
                this.crearNuevoResumen(conv, resumenGenerado);
            }
            conv.setStatusSumary(Boolean.valueOf(true));
            this.conversacionDAO.save((Object)conv);
        }
    }

    private void actualizarResumen(TSummaryConversacion resumen, SumaryResultadoDTO dto) {
        resumen.setTextoResumen(dto.getResumen());
        resumen.setFechaActualizacion(LocalDateTime.now());
        resumen.setPromptTokens(dto.getPromptTokens());
        resumen.setCompletionTokens(dto.getCompletionTokens());
        resumen.setTotalTokens(dto.getTotalTokens());
        this.sumaryDAO.save((Object)resumen);
    }

    private void crearNuevoResumen(TConversacion conv, SumaryResultadoDTO dto) {
        TSummaryConversacion nuevo = new TSummaryConversacion();
        nuevo.setConversacion(conv);
        nuevo.setTextoResumen(dto.getResumen());
        nuevo.setPromptTokens(dto.getPromptTokens());
        nuevo.setCompletionTokens(dto.getCompletionTokens());
        nuevo.setTotalTokens(dto.getTotalTokens());
        nuevo.setProcesado(Boolean.valueOf(true));
        nuevo.setFechaRegistro(LocalDateTime.now());
        nuevo.setFechaActualizacion(LocalDateTime.now());
        this.sumaryDAO.save((Object)nuevo);
    }

    public void procesarCompromisosPendientes() {
        List conversaciones = this.conversacionDAO.findByStatusPromiseFalse();
        LocalDateTime ahora = LocalDateTime.now();
        LocalDateTime hace24Horas = ahora.minusHours(24L);
        for (TConversacion conv : conversaciones) {
            String texto;
            String promptCompromiso;
            CompromisoPagoDTO compromisoDTO;
            List mensajes = this.mensajeDAO.findByConversacionIdAndFechaRegistroBetween(conv.getId(), hace24Horas, ahora);
            if (mensajes.isEmpty() || (compromisoDTO = this.chatapiService.GeneratePromiseDTO(promptCompromiso = PromptUtils.PROMPT_COMPROMISO_PAGO((String)(texto = mensajes.stream().map(m -> m.getRemitente() + ": " + m.getMensaje()).collect(Collectors.joining("\n")))))) == null || !compromisoDTO.getCompromisoPago().booleanValue()) continue;
            TCompromisoPago compromiso = new TCompromisoPago();
            compromiso.setConversacion(conv);
            compromiso.setCompromisoPago(compromisoDTO.getCompromisoPago());
            compromiso.setMonto(compromisoDTO.getMonto());
            compromiso.setFecha(compromisoDTO.getFecha());
            compromiso.setFormaPago(compromisoDTO.getFormaPago());
            compromiso.setPromptTokens(compromisoDTO.getPromptTokens());
            compromiso.setCompletionTokens(compromisoDTO.getCompletionTokens());
            compromiso.setTotalTokens(compromisoDTO.getTotalTokens());
            compromiso.setFechaRegistro(LocalDateTime.now());
            this.compromisoPagoDAO.save((Object)compromiso);
            conv.setStatusPromise(Boolean.valueOf(true));
            this.conversacionDAO.save((Object)conv);
        }
    }

    public List<SumaryResultadoDTO> obtenerTodosLosResumenes(Long idConversacion) {
        return this.sumaryDAO.findAllByConversacionId(idConversacion).stream().map(r -> new SumaryResultadoDTO(r.getTextoResumen(), r.getPromptTokens(), r.getCompletionTokens(), r.getTotalTokens(), r.getConversacion().getId(), r.getFechaRegistro(), r.getFechaActualizacion())).toList();
    }

    public SumaryResultadoDTO obtenerUltimoResumen(Long idConversacion) {
        TSummaryConversacion resumenOpt = this.sumaryDAO.findTopByConversacionIdOrderByFechaRegistroDesc(idConversacion);
        if (resumenOpt != null) {
            TSummaryConversacion r = resumenOpt;
            return new SumaryResultadoDTO(r.getTextoResumen(), r.getPromptTokens(), r.getCompletionTokens(), r.getTotalTokens(), r.getConversacion().getId(), r.getFechaRegistro(), r.getFechaActualizacion());
        }
        return null;
    }

    @Generated
    public SumaryConversacionServiceImpl(TConversacionDAO conversacionDAO, TMensajeDAO mensajeDAO, TSumaryConversacionDAO sumaryDAO, IAService chatapiService, TCompromisoPagoDAO compromisoPagoDAO) {
        this.conversacionDAO = conversacionDAO;
        this.mensajeDAO = mensajeDAO;
        this.sumaryDAO = sumaryDAO;
        this.chatapiService = chatapiService;
        this.compromisoPagoDAO = compromisoPagoDAO;
    }
}

