/*
 * Decompiled with CFR 0.152.
 */
package com.tws.lhiavoice.service.impl;

import com.tws.lhiavoice.models.dto.DetalleLlamadaDTO;
import com.tws.lhiavoice.models.dto.GrabacionDTO;
import com.tws.lhiavoice.models.dto.InteraccionesDiaDTO;
import com.tws.lhiavoice.models.dto.TotalMinutosDTO;
import com.tws.lhiavoice.repository.ReportDAO;
import com.tws.lhiavoice.repository.TConversacionDAO;
import com.tws.lhiavoice.service.ReportService;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
implements ReportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportServiceImpl.class);
    private final ReportDAO reportDAO;
    private final TConversacionDAO conversacionDAO;
    private final Environment env;

    public Long totalConversaciones(String desde, String hasta) {
        LocalDateTime start = this.parseDateTime(desde, false);
        LocalDateTime end = this.parseDateTime(hasta, true);
        return this.reportDAO.totalConversaciones(start, end);
    }

    public List<DetalleLlamadaDTO> detalleLlamadas(String desde, String hasta) {
        LocalDateTime start = this.parseDateTime(desde, false);
        LocalDateTime end = this.parseDateTime(hasta, true);
        return this.reportDAO.detalleLlamadas(start, end).stream().map(obj -> new DetalleLlamadaDTO(Long.valueOf(((Number)obj[0]).longValue()), (String)obj[1], (String)obj[2], obj[3] != null ? ((Timestamp)obj[3]).toLocalDateTime() : null, obj[4] != null ? ((Timestamp)obj[4]).toLocalDateTime() : null, obj[5] != null ? obj[5].toString() : null)).toList();
    }

    public TotalMinutosDTO totalMinutos(String desde, String hasta) {
        LocalDateTime start = this.parseDateTime(desde, false);
        LocalDateTime end = this.parseDateTime(hasta, true);
        Double total = this.reportDAO.totalMinutos(start, end);
        return new TotalMinutosDTO(start != null ? start.toLocalDate() : null, end != null ? end.toLocalDate() : null, Double.valueOf(total != null ? total : 0.0));
    }

    public List<InteraccionesDiaDTO> interaccionesPorDia(String desde, String hasta) {
        LocalDateTime start = this.parseDateTime(desde, false);
        LocalDateTime end = this.parseDateTime(hasta, true);
        return this.reportDAO.interaccionesPorDia(start, end).stream().map(obj -> {
            LocalDate fecha = ((Date)obj[0]).toLocalDate();
            Long total = ((Number)obj[1]).longValue();
            return new InteraccionesDiaDTO(fecha, total);
        }).toList();
    }

    private LocalDateTime parseDateTime(String dateStr, boolean endOfDay) {
        if (dateStr == null || dateStr.isEmpty()) {
            return null;
        }
        if (dateStr.length() == 10) {
            LocalDate date = LocalDate.parse(dateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            return endOfDay ? date.atTime(23, 59, 59) : date.atStartOfDay();
        }
        if (dateStr.contains("T")) {
            return LocalDateTime.parse(dateStr, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        return LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public GrabacionDTO obtenerGrabacion(Long idConversacion) {
        String archivo = this.conversacionDAO.findArchivoByConversacion(idConversacion);
        if (archivo == null) {
            throw new RuntimeException("No se encontr\u00f3 grabaci\u00f3n para la conversaci\u00f3n " + idConversacion);
        }
        return new GrabacionDTO(idConversacion, archivo, this.env.getProperty("url-asterisk") + "/" + archivo);
    }

    @Generated
    public ReportServiceImpl(ReportDAO reportDAO, TConversacionDAO conversacionDAO, Environment env) {
        this.reportDAO = reportDAO;
        this.conversacionDAO = conversacionDAO;
        this.env = env;
    }
}

