/*
 * Decompiled with CFR 0.152.
 */
package com.tws.lhiavoice.service.impl;

import com.tws.lhiavoice.models.dto.CompromisoPagoDTO;
import com.tws.lhiavoice.models.dto.InteraccionDTO;
import com.tws.lhiavoice.models.dto.SumaryResultadoDTO;
import com.tws.lhiavoice.service.IAService;
import java.util.List;
import lombok.Generated;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IAServiceImpl
implements IAService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IAServiceImpl.class);
    private final Environment env;
    private final RestTemplate restTemplate = new RestTemplate();

    public String respondePreguntasV2(List<InteraccionDTO> lstConversation) {
        try {
            JSONObject requestBody = new JSONObject();
            requestBody.put("model", (Object)this.env.getProperty("openai.modelAnswer2"));
            requestBody.put("max_tokens", 450);
            requestBody.put("messages", (Object)new JSONArray(lstConversation));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(this.env.getProperty("openai.apiKey"));
            HttpEntity request = new HttpEntity((Object)requestBody.toString(), (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(this.env.getProperty("openai.urlAnswer2"), (Object)request, String.class, new Object[0]);
            JSONObject responseJson = new JSONObject((String)response.getBody());
            JSONArray choices = responseJson.getJSONArray("choices");
            JSONObject choiceObj = choices.getJSONObject(0);
            JSONObject messageObj = choiceObj.getJSONObject("message");
            String content = messageObj.getString("content");
            System.out.println("Respuesta GPT: " + content);
            return content;
        }
        catch (Exception e) {
            System.err.println("Error al invocar OpenAI: " + e.getMessage());
            return "{\"error\":\"No se pudo procesar la respuesta\"}";
        }
    }

    public SumaryResultadoDTO GenerateSumaryDAO(String textoConversacion) {
        try {
            JSONArray messages = new JSONArray();
            JSONObject userMessage = new JSONObject();
            userMessage.put("role", (Object)"user");
            userMessage.put("content", (Object)("Analiza la siguiente conversaci\u00f3n y genera un resumen claro y conciso en espa\u00f1ol:\n\n" + textoConversacion));
            messages.put((Object)userMessage);
            JSONObject requestBody = new JSONObject();
            requestBody.put("model", (Object)this.env.getProperty("openai.modelAnswer2"));
            requestBody.put("max_tokens", 450);
            requestBody.put("messages", (Object)messages);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(this.env.getProperty("openai.apiKey"));
            HttpEntity request = new HttpEntity((Object)requestBody.toString(), (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(this.env.getProperty("openai.urlAnswer2"), (Object)request, String.class, new Object[0]);
            JSONObject responseJson = new JSONObject((String)response.getBody());
            JSONArray choices = responseJson.getJSONArray("choices");
            JSONObject choiceObj = choices.getJSONObject(0);
            JSONObject messageObj = choiceObj.getJSONObject("message");
            String content = messageObj.getString("content");
            JSONObject usage = responseJson.optJSONObject("usage");
            int promptTokens = usage != null ? usage.optInt("prompt_tokens", 0) : 0;
            int completionTokens = usage != null ? usage.optInt("completion_tokens", 0) : 0;
            int totalTokens = usage != null ? usage.optInt("total_tokens", 0) : 0;
            return new SumaryResultadoDTO(content, promptTokens, completionTokens, totalTokens);
        }
        catch (Exception e) {
            System.err.println("Error al invocar OpenAI: " + e.getMessage());
            return new SumaryResultadoDTO("Error al procesar", 0, 0, 0);
        }
    }

    public CompromisoPagoDTO GeneratePromiseDTO(String textoConversacion) {
        try {
            JSONArray messages = new JSONArray();
            JSONObject userMessage = new JSONObject();
            userMessage.put("role", (Object)"user");
            userMessage.put("content", (Object)("Analiza la siguiente conversaci\u00f3n y genera un resumen claro y conciso en espa\u00f1ol:\n\n" + textoConversacion));
            messages.put((Object)userMessage);
            JSONObject requestBody = new JSONObject();
            requestBody.put("model", (Object)this.env.getProperty("openai.modelAnswer2"));
            requestBody.put("max_tokens", 450);
            requestBody.put("messages", (Object)messages);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(this.env.getProperty("openai.apiKey"));
            HttpEntity request = new HttpEntity((Object)requestBody.toString(), (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(this.env.getProperty("openai.urlAnswer2"), (Object)request, String.class, new Object[0]);
            JSONObject responseJson = new JSONObject((String)response.getBody());
            JSONArray choices = responseJson.getJSONArray("choices");
            JSONObject choiceObj = choices.getJSONObject(0);
            JSONObject messageObj = choiceObj.getJSONObject("message");
            String content = messageObj.getString("content");
            JSONObject usage = responseJson.optJSONObject("usage");
            int promptTokens = usage != null ? usage.optInt("prompt_tokens", 0) : 0;
            int completionTokens = usage != null ? usage.optInt("completion_tokens", 0) : 0;
            int totalTokens = usage != null ? usage.optInt("total_tokens", 0) : 0;
            return new CompromisoPagoDTO(content, promptTokens, completionTokens, totalTokens);
        }
        catch (Exception e) {
            System.err.println("Error al invocar OpenAI: " + e.getMessage());
            return new CompromisoPagoDTO("Error al procesar", 0, 0, 0);
        }
    }

    @Generated
    public IAServiceImpl(Environment env) {
        this.env = env;
    }
}

