/*
 * Decompiled with CFR 0.152.
 */
package com.tws.lhiavoice.repository;

import com.tws.lhiavoice.models.TMensaje;
import com.tws.lhiavoice.models.view.MensajeView;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface TMensajeDAO
extends JpaRepository<TMensaje, Long> {
    @Query(value="    SELECT COUNT(m) > 0\n    FROM TMensaje m\n    WHERE m.conversacion.conversationId = :conversationId\n      AND m.remitente = :remitente\n      AND m.interaction = :interaction\n")
    public boolean existsByConversacion(String var1, String var2, String var3);

    @Query(value="    SELECT\n        m.id AS id,\n        m.remitente AS remitente,\n        m.mensaje AS mensaje,\n        m.fechaRegistro AS fechaRegistro,\n        m.tipoMensaje AS tipoMensaje,\n        m.callerId AS callerId,\n        m.exten AS exten,\n        m.interaction AS interaction,\n        m.conversacion.id AS idConversacion\n    FROM TMensaje m\n    WHERE m.fechaRegistro BETWEEN :desde AND :hasta\n    ORDER BY m.fechaRegistro ASC\n")
    public List<MensajeView> findMensajesPorFechas(@Param(value="desde") LocalDateTime var1, @Param(value="hasta") LocalDateTime var2);

    public List<TMensaje> findByConversacionIdAndFechaRegistroBetween(Long var1, LocalDateTime var2, LocalDateTime var3);
}

