/*
 * Decompiled with CFR 0.152.
 */
package com.tws.lhiavoice.repository;

import com.tws.lhiavoice.models.TConversacion;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ReportDAO
extends JpaRepository<TConversacion, Long> {
    @Query(value="SELECT COUNT(*)\nFROM lhiavoice.conversacion c\nWHERE c.fecha_inicio BETWEEN :desde AND :hasta\n", nativeQuery=true)
    public Long totalConversaciones(@Param(value="desde") LocalDateTime var1, @Param(value="hasta") LocalDateTime var2);

    @Query(value="SELECT c.id,\n       c.conversation_id,\n       c.estado,\n       MIN(mc.fecha_registro),\n       MAX(mc.fecha_registro),\n       AGE(MAX(mc.fecha_registro), MIN(mc.fecha_registro))\nFROM lhiavoice.mensajes_conversacion mc\nJOIN lhiavoice.conversacion c ON c.id = mc.id_conversacion\nWHERE mc.fecha_registro BETWEEN :desde AND :hasta\nGROUP BY c.id, c.conversation_id, c.estado\n", nativeQuery=true)
    public List<Object[]> detalleLlamadas(@Param(value="desde") LocalDateTime var1, @Param(value="hasta") LocalDateTime var2);

    @Query(value="WITH duraciones AS (\n    SELECT c.id,\n           EXTRACT(EPOCH FROM (MAX(mc.fecha_registro) - MIN(mc.fecha_registro)))/60 AS minutos_llamada\n    FROM lhiavoice.mensajes_conversacion mc\n    JOIN lhiavoice.conversacion c ON c.id = mc.id_conversacion\n    WHERE mc.fecha_registro BETWEEN :desde AND :hasta\n    GROUP BY c.id\n)\nSELECT SUM(minutos_llamada)\nFROM duraciones\n", nativeQuery=true)
    public Double totalMinutos(@Param(value="desde") LocalDateTime var1, @Param(value="hasta") LocalDateTime var2);

    @Query(value="SELECT DATE(mc.fecha_registro) AS fecha, COUNT(*) AS total_interacciones\nFROM lhiavoice.mensajes_conversacion mc\nWHERE mc.fecha_registro BETWEEN :desde AND :hasta\nGROUP BY DATE(mc.fecha_registro)\nORDER BY fecha\n", nativeQuery=true)
    public List<Object[]> interaccionesPorDia(@Param(value="desde") LocalDateTime var1, @Param(value="hasta") LocalDateTime var2);
}

