/*
 * Decompiled with CFR 0.152.
 */
package com.tws.lhiavoice.middleware;

import com.tws.lhiavoice.middleware.CachedBodyHttpServletRequest;
import com.tws.lhiavoice.models.audit.Auditoria;
import com.tws.lhiavoice.repository.TAuditoriaDAO;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class RequestLoggingFilter
extends OncePerRequestFilter {
    private final TAuditoriaDAO auditoriaDAO;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        CachedBodyHttpServletRequest cachedRequest = new CachedBodyHttpServletRequest(request);
        String method = cachedRequest.getMethod();
        String uri = cachedRequest.getRequestURI();
        StringBuilder headers = new StringBuilder();
        cachedRequest.getHeaderNames().asIterator().forEachRemaining(header -> headers.append((String)header).append(": ").append(cachedRequest.getHeader(header)).append("\n"));
        String body = null;
        if ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) {
            body = cachedRequest.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        }
        Auditoria audit = new Auditoria();
        audit.setMetodo(method);
        audit.setUrl(uri);
        audit.setHeaders(headers.toString());
        audit.setCuerpo(body);
        this.auditoriaDAO.save((Object)audit);
        filterChain.doFilter((ServletRequest)cachedRequest, (ServletResponse)response);
    }

    @Generated
    public RequestLoggingFilter(TAuditoriaDAO auditoriaDAO) {
        this.auditoriaDAO = auditoriaDAO;
    }
}

