/*
 * Decompiled with CFR 0.152.
 */
package com.tws.lhiavoice.controller;

import com.tws.lhiavoice.models.TLlamada;
import com.tws.lhiavoice.models.request.MensajeRequest;
import com.tws.lhiavoice.service.TConversacionService;
import com.tws.lhiavoice.service.TllamadaService;
import com.tws.lhiavoice.utils.ApiResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/interaccion"})
public class TInteraccionController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TInteraccionController.class);
    private final TllamadaService llamadaService;
    private final TConversacionService conversacionService;

    @PostMapping
    public ResponseEntity<ApiResponse<TLlamada>> crear(@RequestBody TLlamada llamada) {
        return ResponseEntity.ok((Object)this.llamadaService.registrarLlamada(llamada));
    }

    @GetMapping(value={"/{numero}"})
    public ApiResponse<List<TLlamada>> obtenerPorNumero(@PathVariable String numero) {
        return this.llamadaService.obtenerPorNumero(numero);
    }

    @PostMapping(value={"/mensaje-ia"})
    public ResponseEntity<ApiResponse<String>> guardarInteracciones(@RequestBody List<MensajeRequest> mensajes) {
        log.info("llega 1 {} = {}", mensajes);
        for (MensajeRequest mensaje : mensajes) {
            log.info("llega en for 1 {} = {}", (Object)mensaje);
            ApiResponse resultado = this.conversacionService.agregarMensaje(mensaje);
            log.info("llega en for 1");
            if (resultado.getStatus() == 200) continue;
            log.info("llega en if {} = {}", (Object)resultado.getMessage());
            return ResponseEntity.status((int)resultado.getStatus()).body((Object)ApiResponse.error((int)resultado.getStatus(), (String)resultado.getMessage()));
        }
        return ResponseEntity.ok((Object)ApiResponse.success((Object)"Interacci\u00f3n registrada correctamente"));
    }

    @Generated
    public TInteraccionController(TllamadaService llamadaService, TConversacionService conversacionService) {
        this.llamadaService = llamadaService;
        this.conversacionService = conversacionService;
    }
}

