/*
 * Decompiled with CFR 0.152.
 */
package com.tws.lhiavoice.controller;

import com.tws.lhiavoice.models.dto.ConversacionDTO;
import com.tws.lhiavoice.models.dto.DetalleLlamadaDTO;
import com.tws.lhiavoice.models.dto.GrabacionDTO;
import com.tws.lhiavoice.models.dto.InteraccionesDiaDTO;
import com.tws.lhiavoice.models.dto.SumaryResultadoDTO;
import com.tws.lhiavoice.models.dto.TotalMinutosDTO;
import com.tws.lhiavoice.service.ReportService;
import com.tws.lhiavoice.service.SumaryConversacionService;
import com.tws.lhiavoice.service.TMensajeService;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/report/"})
public class DashboardReportController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DashboardReportController.class);
    private final TMensajeService mensajeService;
    private final ReportService reportService;
    private final SumaryConversacionService sumariService;

    @PostMapping(value={"mensajes"})
    public ResponseEntity<List<ConversacionDTO>> getMensajes(@RequestParam(value="desde") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime desde, @RequestParam(value="hasta") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime hasta) {
        List mensajes = this.mensajeService.obtenerConversacionesPorFecha(desde, hasta);
        return ResponseEntity.ok((Object)mensajes);
    }

    @PostMapping(value={"/total-conversaciones"})
    public Long totalConversaciones(@RequestParam(value="desde") String desde, @RequestParam(value="hasta") String hasta) {
        return this.reportService.totalConversaciones(desde, hasta);
    }

    @PostMapping(value={"/detalle-llamadas"})
    public ResponseEntity<List<DetalleLlamadaDTO>> detalleLlamadas(@RequestParam(value="desde") String desde, @RequestParam(value="hasta") String hasta) {
        List detalles = this.reportService.detalleLlamadas(desde, hasta);
        return ResponseEntity.ok((Object)detalles);
    }

    @PostMapping(value={"/total-minutos"})
    public ResponseEntity<TotalMinutosDTO> totalMinutos(@RequestParam(value="desde") String desde, @RequestParam(value="hasta") String hasta) {
        TotalMinutosDTO total = this.reportService.totalMinutos(desde, hasta);
        return ResponseEntity.ok((Object)total);
    }

    @PostMapping(value={"/interacciones-dia"})
    public ResponseEntity<List<InteraccionesDiaDTO>> interaccionesPorDia(@RequestParam(value="desde") String desde, @RequestParam(value="hasta") String hasta) {
        List interaccion = this.reportService.interaccionesPorDia(desde, hasta);
        return ResponseEntity.ok((Object)interaccion);
    }

    @PostMapping(value={"record/{idConversacion}"})
    public ResponseEntity<GrabacionDTO> getGrabacion(@PathVariable Long idConversacion) {
        return ResponseEntity.ok((Object)this.reportService.obtenerGrabacion(idConversacion));
    }

    @PostMapping(value={"sumary/one/{idConversacion}"})
    public ResponseEntity<SumaryResultadoDTO> obtenerUltimoResumen(@PathVariable Long idConversacion) {
        SumaryResultadoDTO dto = this.sumariService.obtenerUltimoResumen(idConversacion);
        if (dto == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"sumary/{idConversacion}/historial"})
    public ResponseEntity<List<SumaryResultadoDTO>> obtenerHistorial(@PathVariable Long idConversacion) {
        return ResponseEntity.ok((Object)this.sumariService.obtenerTodosLosResumenes(idConversacion));
    }

    @Generated
    public DashboardReportController(TMensajeService mensajeService, ReportService reportService, SumaryConversacionService sumariService) {
        this.mensajeService = mensajeService;
        this.reportService = reportService;
        this.sumariService = sumariService;
    }
}

