/*
 * Decompiled with CFR 0.152.
 */
package com.tcloud.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tcloud.logic.entity.dto.ProcessVoucherDto;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

public class FileAnaliticsUtils {
    public static HttpHeaders createHeaders(String apiKey) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(apiKey);
        return headers;
    }

    public static boolean isJsonResponse(ResponseEntity<String> response) {
        return response.getHeaders().getContentType().includes(MediaType.APPLICATION_JSON);
    }

    public static Map<String, Object> createRequestBody(String urlImage, String modelAnswer4, int maxTokens) {
        Map<String, String> message1 = Map.of("type", "text", "text", "Analiza los resultados de las Metricas Categorizadas, el valor de la metrica, indice, el bajo consumo a partir de esta imagen de consumo de AWS");
        Map<String, Map<String, String>> message2 = Map.of("type", "image_url", "image_url", Map.of("url", urlImage));
        Map<String, List<Map>> userMessage = Map.of("role", "user", "content", Arrays.asList(message1, message2));
        return Map.of("model", modelAnswer4, "messages", Collections.singletonList(userMessage), "max_tokens", 300);
    }

    public static ProcessVoucherDto processResponse(String responseBody) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(responseBody);
            String content = rootNode.path("choices").get(0).path("message").path("content").asText();
            int totalTokens = rootNode.path("usage").path("total_tokens").asInt();
            if (content.contains("documento_no_valido")) {
                String newContent = content.replace("documento_no_valido:", "");
                if (!newContent.isEmpty()) {
                    return new ProcessVoucherDto(newContent.trim(), totalTokens, false);
                }
                return new ProcessVoucherDto("La imagen no contiene informaci\u00f3n relacionada con una metrica estadistica", totalTokens, false);
            }
            return new ProcessVoucherDto(content, totalTokens, true);
        }
        catch (Exception e) {
            return new ProcessVoucherDto("La imagen no contiene informaci\u00f3n relacionada con una metrica estadistica", 0, false);
        }
    }
}

